/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.zert;

import java.util.HashMap;
import java.util.Map;

public enum CertDigestAlgorithm {
    UNKNOWN(0),
    NONE(1),
    MD2(2),
    MD5(3),
    SHA1(4),
    SHA224(5),
    SHA256(6),
    SHA384(7),
    SHA512(8),
    NOT_DEFINED(-16);

    private static Map<Integer, CertDigestAlgorithm> valueMap;
    private final int certdigestalgorithm;

    private CertDigestAlgorithm(int certdigestalgorithm) {
        this.certdigestalgorithm = certdigestalgorithm;
    }

    public static CertDigestAlgorithm from(int value) {
        CertDigestAlgorithm result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int certdigestalgorithm() {
        return this.certdigestalgorithm;
    }

    static {
        valueMap = new HashMap<Integer, CertDigestAlgorithm>();
        for (CertDigestAlgorithm x : CertDigestAlgorithm.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.certdigestalgorithm, x);
        }
    }
}

