/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.zert;

import java.util.HashMap;
import java.util.Map;

public enum EncryptionAlgorithm {
    UNKNOWN(0),
    NONE(1),
    DES(2),
    DES_40(3),
    _3DES(4),
    RC2_40(5),
    RC2_128(6),
    RC2(7),
    RC4_40(8),
    RC4_128(9),
    RC4_256(10),
    RC4(11),
    AES_CBC_128(12),
    AES_CBC_192(13),
    AES_CBC_256(14),
    AES_CTR_128(15),
    AES_CTR_192(16),
    AES_CTR_256(17),
    AES_GCM_128(18),
    AES_GCM_256(19),
    AES_CCM_128(20),
    AES_CCM_256(21),
    AES_CCM8_128(22),
    AES_CCM8_256(23),
    AES_256(24),
    BLOWFISH(25),
    BLOWFISH_CBC(26),
    CAST_128_CBC(27),
    ARCFOUR_128(28),
    ARCFOUR_256(29),
    ARCFOUR(30),
    RIJNDAEL_CBC(31),
    ACSS(32),
    ARIA_128_CBC(33),
    ARIA_256_CBC(34),
    ARIA_128_GCM(35),
    ARIA_256_GCM(36),
    CAMELLIA_128_CBC(37),
    CAMELLIA_256_CBC(38),
    CAMELLIA_128_GCM(39),
    CAMELLIA_256_GCM(40),
    CHACHA20_POLY1305(41),
    IDEA_CBC(42),
    SEED_CBC(43),
    FORTEZZA_CBC(44),
    GOST28147(45),
    TWOFISH_CBC_256(46),
    TWOFISH_CBC(47),
    TWOFISH_CBC_192(48),
    TWOFISH_CBC_128(49),
    SERPENT_CBC_256(50),
    SERPENT_CBC_192(51),
    SERPENT_CBC_128(52),
    NOT_DEFINED(-16);

    private static Map<Integer, EncryptionAlgorithm> valueMap;
    private final int encryptionalgorithm;

    private EncryptionAlgorithm(int encryptionalgorithm) {
        this.encryptionalgorithm = encryptionalgorithm;
    }

    public static EncryptionAlgorithm from(int value) {
        EncryptionAlgorithm result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int encryptionalgorithm() {
        return this.encryptionalgorithm;
    }

    static {
        valueMap = new HashMap<Integer, EncryptionAlgorithm>();
        for (EncryptionAlgorithm x : EncryptionAlgorithm.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.encryptionalgorithm, x);
        }
    }
}

