/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.controlblock.Jfcb;
import com.blackhillsoftware.smf.dataset.Dsorg;
import com.blackhillsoftware.smf.dataset.Recfm;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf14.AdditionalDatasetCharacteristics;
import com.blackhillsoftware.smf.smf14.CcsidInformationSection;
import com.blackhillsoftware.smf.smf14.CompressedFormatDatasetSection;
import com.blackhillsoftware.smf.smf14.DasdExtension;
import com.blackhillsoftware.smf.smf14.EncryptedDasdDatasetSection;
import com.blackhillsoftware.smf.smf14.ExtendedInformationSegment;
import com.blackhillsoftware.smf.smf14.HiperBatchSection;
import com.blackhillsoftware.smf.smf14.PdseStatistics;
import com.blackhillsoftware.smf.smf14.RasSection;
import com.blackhillsoftware.smf.smf14.SmsClassSection;
import com.blackhillsoftware.smf.smf14.StepInformationSection;
import com.blackhillsoftware.smf.smf14.TapeEncryptionData;
import com.blackhillsoftware.smf.smf14.TapeExtension;
import com.blackhillsoftware.smf.smf14.TiotSection;
import com.blackhillsoftware.smf.smf14.UcbSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Smf14Record
extends SmfRecord {
    public static final int SMF14RV0 = 128;
    public static final int SMF14EOV = 64;
    public static final int SMF14DAD = 32;
    public static final int SMF14TDS = 16;
    public static final int SMF14DDA = 8;
    public static final int SMF14IS = 4;
    public static final int SMF14JIS = 2;
    public static final int SMF14VIO = 1;
    public static final int SMF14IPD = 128;
    public static final int SMF14TRC = 64;
    public static final int SMF14NSG = 32;
    public static final int SMF14STR = 16;
    public static final int SMF14HBT = 8;
    public static final int SMF14XSG = 4;
    public static final int SMF14TCL = 2;
    public static final int SMF14ABD = 1;
    public static final int DCBDSGIS = 128;
    public static final int DCBDSGPS = 64;
    public static final int DCBDSGDA = 32;
    public static final int DCBDSGCX = 16;
    public static final int DCBDSGPO = 2;
    public static final int DCBDSGU = 1;
    public static final int DCBDSGGS = 128;
    public static final int DCBDSGTX = 64;
    public static final int DCBDSGTQ = 32;
    public static final int DCBACBM = 8;
    public static final int DCBDSGTR = 4;
    public static final int DCBRECLA = 224;
    public static final int DCBRECD = 32;
    public static final int DCBRECL = 192;
    public static final int DCBRECF = 128;
    public static final int DCBRECV = 64;
    public static final int DCBRECU = 192;
    public static final int DCBRECTO = 32;
    public static final int DCBRECBR = 16;
    public static final int DCBRECSB = 8;
    public static final int DCBRECCC = 6;
    public static final int DCBRECCA = 4;
    public static final int DCBRECCM = 2;
    public static final int DCBRECC = 0;
    public static final int DCBRECKL = 1;
    public static final int DCBOFLWR = 128;
    public static final int DCBOFIOD = 128;
    public static final int DCBOFLRB = 64;
    public static final int DCBOFEOV = 32;
    public static final int DCBOFOPN = 16;
    public static final int DCBOFPPC = 8;
    public static final int DCBOFTM = 4;
    public static final int DCBOFUEX = 2;
    public static final int DCBOLOCK = 2;
    public static final int DCBOFIOF = 1;
    public static final int DCBOBUSY = 1;
    public static final int DCBOPTTO = 64;
    public static final int DCBOPTE = 32;
    public static final int DCBOPTF = 16;
    public static final int DCBOPTA = 8;
    public static final int DCBOPTDB = 4;
    public static final int DCBOPTRE = 2;
    public static final int DCBOPTRB = 1;
    public static final int DEBDISP = 192;
    public static final int DEBDSOLD = 64;
    public static final int DEBDSMOD = 128;
    public static final int DEBDSNEW = 192;
    public static final int DEBEOF = 32;
    public static final int DEBRLSE = 16;
    public static final int DEBDCB = 8;
    public static final int DEBSPLIT = 4;
    public static final int DEBLABEL = 2;
    public static final int DEBRERR = 1;
    public static final int DEBABEND = 128;
    public static final int DEBPOSIT = 48;
    public static final int DEBRERED = 16;
    public static final int DEBLEAVE = 48;
    public static final int DEBACCS = 15;
    public static final int DEBINPUT = 0;
    public static final int DEBOUTPT = 15;
    public static final int DEBXTEND = 14;
    public static final int DEBINOUT = 3;
    public static final int DEBOUTIN = 7;
    public static final int DEBOTINX = 6;
    public static final int DEBRDBCK = 1;
    public static final int DEBUPDAT = 4;
    public static final int DEBEXFUL = 128;
    private List<UcbSection> m_UcbSections = null;
    private List<CompressedFormatDatasetSection> m_CompressedFormatDatasetSection = null;
    private List<SmsClassSection> m_SmsClassSection = null;
    private List<StepInformationSection> m_StepInformationSection = null;
    private List<CcsidInformationSection> m_CcsidInformationSection = null;
    private List<AdditionalDatasetCharacteristics> m_AdditionalDatasetCharacteristics = null;
    private List<PdseStatistics> m_PdseStatistics = null;
    private List<TapeEncryptionData> m_TapeEncryptionData = null;
    private List<RasSection> m_RasSection = null;
    private List<EncryptedDasdDatasetSection> m_EncryptedDasdDatasetSection = null;

    public Smf14Record(byte[] data) {
        super(data);
        this.checkType();
    }

    protected void checkType() {
        if (this.recordType() != 14 && this.recordType() != 15) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf14Record(SmfRecord record) {
        super(record);
        this.checkType();
    }

    public static Smf14Record from(SmfRecord record) {
        return new Smf14Record(record);
    }

    public static Smf14Record from(byte[] data) {
        return new Smf14Record(data);
    }

    public int smf14len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf14seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf14flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf14rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf14tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf14tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf14dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf14dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf14sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf14jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf14rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf14rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf14rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf14rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf14uid() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public int smf14rin() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public boolean smf14rv0() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 128, Field.smf14rin.length, 0);
    }

    public boolean smf14eov() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 64, Field.smf14rin.length, 0);
    }

    public boolean smf14dad() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 32, Field.smf14rin.length, 0);
    }

    public boolean smf14tds() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 16, Field.smf14rin.length, 0);
    }

    public boolean smf14dda() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 8, Field.smf14rin.length, 0);
    }

    public boolean smf14is() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 4, Field.smf14rin.length, 0);
    }

    public boolean smf14jis() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 2, Field.smf14rin.length, 0);
    }

    public boolean smf14vio() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 1, Field.smf14rin.length, 0);
    }

    public boolean smf14ipd() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 128, Field.smf14rin.length, 1);
    }

    public boolean smf14trc() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 64, Field.smf14rin.length, 1);
    }

    public boolean smf14nsg() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 32, Field.smf14rin.length, 1);
    }

    public boolean smf14str() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 16, Field.smf14rin.length, 1);
    }

    public boolean smf14hbt() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 8, Field.smf14rin.length, 1);
    }

    public boolean smf14xsg() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 4, Field.smf14rin.length, 1);
    }

    public boolean smf14tcl() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 2, Field.smf14rin.length, 1);
    }

    public boolean smf14abd() {
        return Util.ConvertFlag(this.data, this.smf14rin(), 1, Field.smf14rin.length, 1);
    }

    public int smf14sdc() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public int smf14nuc() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public int smf14suc() {
        return Util.ConvertUnsignedBinary1(this.data, 46);
    }

    public int smf14set() {
        return Util.ConvertUnsignedBinary1(this.data, 47);
    }

    public LocalTime smf14ope() {
        return Util.Binary4x100STime(this.data, 48);
    }

    public long smf14opeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public int smftioe1() {
        return Util.ConvertUnsignedBinary1(this.data, 52);
    }

    public int smftioe2() {
        return Util.ConvertUnsignedBinary1(this.data, 53);
    }

    public int smftioe3() {
        return Util.ConvertUnsignedBinary1(this.data, 54);
    }

    public int smftioe4() {
        return Util.ConvertUnsignedBinary1(this.data, 55);
    }

    public String smftioe5() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public int smftioe6() {
        return Util.ConvertUnsignedBinary3(this.data, 64);
    }

    public int smftioe7() {
        return Util.ConvertUnsignedBinary1(this.data, 67);
    }

    public Jfcb smfjfcb1() {
        if (this.data.length >= 244) {
            return Jfcb.create(this.data, 68, 176);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(68) + " Data length: " + Integer.toString(176));
    }

    public Dsorg smfdcbor() {
        return Dsorg.fromDsorgBytes(Util.ConvertUnsignedBinary2(this.data, 244));
    }

    public int smfdcborRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 244);
    }

    public Recfm smfdcbrf() {
        return Recfm.fromRecfmByte(this.smfdcbrfRawValue());
    }

    public int smfdcbrfRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 246);
    }

    public int smfdcbmf() {
        return Util.ConvertUnsignedBinary2(this.data, 247);
    }

    public int smfdcbfl() {
        return Util.ConvertUnsignedBinary1(this.data, 249);
    }

    public int smfdcbop() {
        return Util.ConvertUnsignedBinary1(this.data, 250);
    }

    public int smfdebfl() {
        return Util.ConvertUnsignedBinary1(this.data, 252);
    }

    public int smfdebop() {
        return Util.ConvertUnsignedBinary1(this.data, 253);
    }

    public int smfdebvl() {
        return Util.ConvertUnsignedBinary2(this.data, 254, Short.MAX_VALUE);
    }

    public TiotSection tiotSection() {
        if (this.data.length >= 68) {
            return TiotSection.create(this.data, 52, 16);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(68) + " Data length: " + Integer.toString(176));
    }

    public boolean dcbdsgis() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 128, Field.smfdcbor.length, 0);
    }

    public boolean dcbdsgps() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 64, Field.smfdcbor.length, 0);
    }

    public boolean dcbdsgda() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 32, Field.smfdcbor.length, 0);
    }

    public boolean dcbdsgcx() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 16, Field.smfdcbor.length, 0);
    }

    public boolean dcbdsgpo() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 2, Field.smfdcbor.length, 0);
    }

    public boolean dcbdsgu() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 1, Field.smfdcbor.length, 0);
    }

    public boolean dcbdsggs() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 128, Field.smfdcbor.length, 1);
    }

    public boolean dcbdsgtx() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 64, Field.smfdcbor.length, 1);
    }

    public boolean dcbdsgtq() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 32, Field.smfdcbor.length, 1);
    }

    public boolean dcbacbm() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 8, Field.smfdcbor.length, 1);
    }

    public boolean dcbdsgtr() {
        return Util.ConvertFlag(this.data, this.smfdcborRawValue(), 4, Field.smfdcbor.length, 1);
    }

    public boolean dcbrecd() {
        return Util.ConvertFlag(this.data, this.smfdcbrfRawValue(), 32);
    }

    public boolean dcbrecf() {
        return Util.ConvertEquateValue(this.data, this.smfdcbrfRawValue(), 128, 192);
    }

    public boolean dcbrecv() {
        return Util.ConvertEquateValue(this.data, this.smfdcbrfRawValue(), 64, 192);
    }

    public boolean dcbrecu() {
        return Util.ConvertEquateValue(this.data, this.smfdcbrfRawValue(), 192, 192);
    }

    public boolean dcbrecto() {
        return Util.ConvertFlag(this.data, this.smfdcbrfRawValue(), 32);
    }

    public boolean dcbrecbr() {
        return Util.ConvertFlag(this.data, this.smfdcbrfRawValue(), 16);
    }

    public boolean dcbrecsb() {
        return Util.ConvertFlag(this.data, this.smfdcbrfRawValue(), 8);
    }

    public boolean dcbrecca() {
        return Util.ConvertEquateValue(this.data, this.smfdcbrfRawValue(), 4, 6);
    }

    public boolean dcbreccm() {
        return Util.ConvertEquateValue(this.data, this.smfdcbrfRawValue(), 2, 6);
    }

    public boolean dcbrecc() {
        return Util.ConvertEquateValue(this.data, this.smfdcbrfRawValue(), 0, 6);
    }

    public boolean dcbreckl() {
        return Util.ConvertFlag(this.data, this.smfdcbrfRawValue(), 1);
    }

    public boolean dcboflwr() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 128);
    }

    public boolean dcbofiod() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 128);
    }

    public boolean dcboflrb() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 64);
    }

    public boolean dcbofeov() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 32);
    }

    public boolean dcbofopn() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 16);
    }

    public boolean dcbofppc() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 8);
    }

    public boolean dcboftm() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 4);
    }

    public boolean dcbofuex() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 2);
    }

    public boolean dcbolock() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 2);
    }

    public boolean dcbofiof() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 1);
    }

    public boolean dcbobusy() {
        return Util.ConvertFlag(this.data, this.smfdcbfl(), 1);
    }

    public boolean dcboptto() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 64);
    }

    public boolean dcbopte() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 32);
    }

    public boolean dcboptf() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 16);
    }

    public boolean dcbopta() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 8);
    }

    public boolean dcboptdb() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 4);
    }

    public boolean dcboptre() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 2);
    }

    public boolean dcboptrb() {
        return Util.ConvertFlag(this.data, this.smfdcbop(), 1);
    }

    public boolean debdsold() {
        return Util.ConvertEquateValue(this.data, this.smfdebfl(), 64, 192);
    }

    public boolean debdsmod() {
        return Util.ConvertEquateValue(this.data, this.smfdebfl(), 128, 192);
    }

    public boolean debdsnew() {
        return Util.ConvertEquateValue(this.data, this.smfdebfl(), 192, 192);
    }

    public boolean debeof() {
        return Util.ConvertFlag(this.data, this.smfdebfl(), 32);
    }

    public boolean debrlse() {
        return Util.ConvertFlag(this.data, this.smfdebfl(), 16);
    }

    public boolean debdcb() {
        return Util.ConvertFlag(this.data, this.smfdebfl(), 8);
    }

    public boolean debsplit() {
        return Util.ConvertFlag(this.data, this.smfdebfl(), 4);
    }

    public boolean deblabel() {
        return Util.ConvertFlag(this.data, this.smfdebfl(), 2);
    }

    public boolean debrerr() {
        return Util.ConvertFlag(this.data, this.smfdebfl(), 1);
    }

    public boolean debabend() {
        return Util.ConvertFlag(this.data, this.smfdebop(), 128);
    }

    public boolean debrered() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 16, 48);
    }

    public boolean debleave() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 48, 48);
    }

    public boolean debinput() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 0, 15);
    }

    public boolean deboutpt() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 15, 15);
    }

    public boolean debxtend() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 14, 15);
    }

    public boolean debinout() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 3, 15);
    }

    public boolean deboutin() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 7, 15);
    }

    public boolean debotinx() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 6, 15);
    }

    public boolean debrdbck() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 1, 15);
    }

    public boolean debupdat() {
        return Util.ConvertEquateValue(this.data, this.smfdebop(), 4, 15);
    }

    public int debvolbt() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean debexful() {
        return Util.ConvertFlag(this.data, this.smfdebvl(), 128, Field.smfdebvl.length, 0);
    }

    public TapeExtension tapeExtension() {
        if (!this.smf14dad() && !this.smf14vio()) {
            return TapeExtension.create(this.data, 256, 16);
        }
        return null;
    }

    public DasdExtension dasdExtension() {
        if (this.smf14dad() || this.smf14vio()) {
            return DasdExtension.create(this.data, 256, 16);
        }
        return null;
    }

    private int ucbSectionOffset() {
        return Field.smfdcbor.offset + this.smf14sdc();
    }

    private int hiperbatchSectionOffset() {
        return this.ucbSectionOffset() + this.smf14suc() * this.smf14nuc();
    }

    private int eisDescriptorOffset() {
        return this.hiperbatchSectionOffset() + (this.smf14hbt() ? 20 : 0);
    }

    public HiperBatchSection hiperBatchSection() {
        return this.smf14hbt() ? HiperBatchSection.create(this.data, this.hiperbatchSectionOffset(), 20) : null;
    }

    public int smf14sxs() {
        return Util.ConvertUnsignedBinary2(this.data, this.eisDescriptorOffset());
    }

    public List<UcbSection> ucbSections() {
        this.m_UcbSections = Util.sectionsFromTriplet(this.m_UcbSections, this.data, () -> this.ucbSectionOffset(), () -> this.smf14suc(), () -> this.smf14nuc(), UcbSection::create);
        return this.m_UcbSections;
    }

    public List<CompressedFormatDatasetSection> compressedFormatDatasetSections() {
        this.m_CompressedFormatDatasetSection = this.extendedInformationSegments(this.m_CompressedFormatDatasetSection, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.CompressedFormatDatasetSection, CompressedFormatDatasetSection::create);
        return this.m_CompressedFormatDatasetSection;
    }

    public List<SmsClassSection> smsClassSections() {
        this.m_SmsClassSection = this.extendedInformationSegments(this.m_SmsClassSection, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.SmsClassSection, SmsClassSection::create);
        return this.m_SmsClassSection;
    }

    public List<StepInformationSection> stepInformationSections() {
        this.m_StepInformationSection = this.extendedInformationSegments(this.m_StepInformationSection, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.StepInformationSection, StepInformationSection::create);
        return this.m_StepInformationSection;
    }

    public List<CcsidInformationSection> ccsidInformationSections() {
        this.m_CcsidInformationSection = this.extendedInformationSegments(this.m_CcsidInformationSection, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.CcsidInformationSection, CcsidInformationSection::create);
        return this.m_CcsidInformationSection;
    }

    public List<AdditionalDatasetCharacteristics> additionalDatasetCharacteristics() {
        this.m_AdditionalDatasetCharacteristics = this.extendedInformationSegments(this.m_AdditionalDatasetCharacteristics, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.AdditionalDatasetCharacteristics, AdditionalDatasetCharacteristics::create);
        return this.m_AdditionalDatasetCharacteristics;
    }

    public List<PdseStatistics> pdseStatistics() {
        this.m_PdseStatistics = this.extendedInformationSegments(this.m_PdseStatistics, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.PdseStatistics, PdseStatistics::create);
        return this.m_PdseStatistics;
    }

    public List<TapeEncryptionData> tapeEncryptionData() {
        this.m_TapeEncryptionData = this.extendedInformationSegments(this.m_TapeEncryptionData, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.CompressedFormatDatasetSection, TapeEncryptionData::create);
        return this.m_TapeEncryptionData;
    }

    public List<RasSection> rasSection() {
        this.m_RasSection = this.extendedInformationSegments(this.m_RasSection, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.RasSection, RasSection::create);
        return this.m_RasSection;
    }

    public List<EncryptedDasdDatasetSection> encryptedDasdDatasetSection() {
        this.m_EncryptedDasdDatasetSection = this.extendedInformationSegments(this.m_EncryptedDasdDatasetSection, this.data, ExtendedInformationSegment.ExtendedInformationSegmentType.EncryptedDasdDatasetSection, EncryptedDasdDatasetSection::create);
        return this.m_EncryptedDasdDatasetSection;
    }

    private <T> List<T> extendedInformationSegments(List<T> arg, byte[] data, ExtendedInformationSegment.ExtendedInformationSegmentType targettype, CreateSection<T> builder) {
        int sectionLength;
        if (arg != null) {
            return arg;
        }
        ArrayList<T> result = new ArrayList<T>();
        int extendedInformtionSegmentLength = this.smf14sxs();
        int base = this.eisDescriptorOffset();
        for (int offset = 2; offset < extendedInformtionSegmentLength && base + offset < data.length; offset += sectionLength) {
            sectionLength = Util.ConvertUnsignedBinary2(data, base + offset);
            ExtendedInformationSegment.ExtendedInformationSegmentType type = ExtendedInformationSegment.ExtendedInformationSegmentType.fromInt(Util.ConvertUnsignedBinary1(data, base + offset + ExtendedInformationSegment.Field.smf14sty.offset()));
            if (type != targettype) continue;
            result.add(builder.createSection(data, base + offset + 4, sectionLength - 4));
        }
        return Collections.unmodifiableList(result);
    }

    static enum Field {
        smf14len(0, 2),
        smf14seg(2, 2),
        smf14flg(4, 1),
        smf14rty(5, 1),
        smf14tme(6, 4),
        smf14dte(10, 4),
        smf14sid(14, 4),
        smf14jbn(18, 8),
        smf14rst(26, 4),
        smf14rsd(30, 4),
        smf14uid(34, 8),
        smf14rin(42, 2),
        smf14sdc(44, 1),
        smf14nuc(45, 1),
        smf14suc(46, 1),
        smf14set(47, 1),
        smf14ope(48, 4),
        smftioe1(52, 1),
        smftioe2(53, 1),
        smftioe3(54, 1),
        smftioe4(55, 1),
        smftioe5(56, 8),
        smftioe6(64, 3),
        smftioe7(67, 1),
        smfjfcb1(68, 176),
        smfdcbor(244, 2),
        smfdcbrf(246, 1),
        smfdcbmf(247, 2),
        smfdcbfl(249, 1),
        smfdcbop(250, 1),
        smfdebfl(252, 1),
        smfdebop(253, 1),
        smfdebvl(254, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

