/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;

public final class TapeExtension
extends SmfData {
    public static final int SMF148WN = 128;

    private TapeExtension(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smfdcbbl() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String smfdssno() {
        return Util.ConvertEbcdic(this.data, 4, 6);
    }

    public int smf14tda() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public boolean smf148wn() {
        return Util.ConvertFlag(this.data, this.smf14tda(), 128);
    }

    public LocalDate smf14opd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf14opdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public static TapeExtension create(byte[] Data2, int offset, int length) {
        return new TapeExtension(Data2, offset, length);
    }

    static enum Field {
        smfdcbbl(0, 4),
        smfdssno(4, 6),
        smf14tda(11, 1),
        smf14opd(12, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

