/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class InputDatasetSection
extends SmfData {
    public static final int ICEINSIN = 128;
    public static final int ICEINSNN = 64;
    public static final int ICEINPIP = 128;
    public static final int ICEINSTR = 64;
    public static final int ICEINCPR = 32;
    public static final int ICEINEA = 16;
    public static final int ICEINHFS = 8;
    public static final int ICEINEXP = 128;
    public static final int ICEINVSM = 64;
    public static final int ICEINBSM = 32;
    public static final int ICEINTAP = 128;
    public static final int ICEINDAS = 64;
    public static final int ICEINSPD = 32;
    public static final int ICEINEND = 96;

    private InputDatasetSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int iceinfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean iceinsin() {
        return Util.ConvertFlag(this.data, this.iceinfl1(), 128);
    }

    public boolean iceinsnn() {
        return Util.ConvertFlag(this.data, this.iceinfl1(), 64);
    }

    public int iceinfl2() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean iceinpip() {
        return Util.ConvertFlag(this.data, this.iceinfl2(), 128);
    }

    public boolean iceinstr() {
        return Util.ConvertFlag(this.data, this.iceinfl2(), 64);
    }

    public boolean iceincpr() {
        return Util.ConvertFlag(this.data, this.iceinfl2(), 32);
    }

    public boolean iceinea() {
        return Util.ConvertFlag(this.data, this.iceinfl2(), 16);
    }

    public boolean iceinhfs() {
        return Util.ConvertFlag(this.data, this.iceinfl2(), 8);
    }

    public int iceinamb() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean iceinexp() {
        return Util.ConvertFlag(this.data, this.iceinamb(), 128);
    }

    public boolean iceinvsm() {
        return Util.ConvertFlag(this.data, this.iceinamb(), 64);
    }

    public boolean iceinbsm() {
        return Util.ConvertFlag(this.data, this.iceinamb(), 32);
    }

    public int iceintyp() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean iceintap() {
        return Util.ConvertFlag(this.data, this.iceintyp(), 128);
    }

    public boolean iceindas() {
        return Util.ConvertFlag(this.data, this.iceintyp(), 64);
    }

    public boolean iceinspd() {
        return Util.ConvertFlag(this.data, this.iceintyp(), 32);
    }

    public int iceinrcf() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long iceinbyt() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger iceinbytAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long iceinamc() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger iceinamcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public int iceinlrl() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int iceinbkz() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public String iceinddn() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String iceinnam() {
        return Util.ConvertEbcdic(this.data, 40, 44);
    }

    public String iceinvol() {
        return Util.ConvertEbcdic(this.data, 84, 6);
    }

    public long iceinbkf() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public static InputDatasetSection create(byte[] Data2, int offset, int length) {
        return new InputDatasetSection(Data2, offset, length);
    }

    static enum Field {
        iceinfl1(0, 1),
        iceinfl2(1, 1),
        iceinamb(2, 1),
        iceintyp(3, 1),
        iceinrcf(4, 1),
        iceinbyt(8, 8),
        iceinamc(16, 8),
        iceinlrl(26, 2),
        iceinbkz(30, 2),
        iceinddn(32, 8),
        iceinnam(40, 44),
        iceinvol(84, 6),
        iceinbkf(92, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

