/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class OutfilDatasetSection
extends SmfData {
    public static final int ICEOFPIP = 128;
    public static final int ICEOFSTR = 64;
    public static final int ICEOFCPR = 32;
    public static final int ICEOFEA = 16;
    public static final int ICEOFHFS = 8;
    public static final int ICEOFEXP = 128;
    public static final int ICEOFVSM = 64;
    public static final int ICEOFBSM = 32;
    public static final int ICEOFTAP = 128;
    public static final int ICEOFDAS = 64;
    public static final int ICEOFSPD = 32;
    public static final int ICEOFSER = 128;
    public static final int ICEOFIOS = 64;
    public static final int ICEOFSPL = 32;
    public static final int ICEOFORC = 16;
    public static final int ICEOFCVT = 8;
    public static final int ICEOFREP = 4;
    public static final int ICEOFVFL = 2;
    public static final int ICEOFVTR = 1;
    public static final int ICEOFRMC = 128;
    public static final int ICEOFEND = 104;

    private OutfilDatasetSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int iceoffl1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean iceofpip() {
        return Util.ConvertFlag(this.data, this.iceoffl1(), 128);
    }

    public boolean iceofstr() {
        return Util.ConvertFlag(this.data, this.iceoffl1(), 64);
    }

    public boolean iceofcpr() {
        return Util.ConvertFlag(this.data, this.iceoffl1(), 32);
    }

    public boolean iceofea() {
        return Util.ConvertFlag(this.data, this.iceoffl1(), 16);
    }

    public boolean iceofhfs() {
        return Util.ConvertFlag(this.data, this.iceoffl1(), 8);
    }

    public int iceofamb() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean iceofexp() {
        return Util.ConvertFlag(this.data, this.iceofamb(), 128);
    }

    public boolean iceofvsm() {
        return Util.ConvertFlag(this.data, this.iceofamb(), 64);
    }

    public boolean iceofbsm() {
        return Util.ConvertFlag(this.data, this.iceofamb(), 32);
    }

    public int iceoftyp() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean iceoftap() {
        return Util.ConvertFlag(this.data, this.iceoftyp(), 128);
    }

    public boolean iceofdas() {
        return Util.ConvertFlag(this.data, this.iceoftyp(), 64);
    }

    public boolean iceofspd() {
        return Util.ConvertFlag(this.data, this.iceoftyp(), 32);
    }

    public int iceofrcf() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public int iceofprm() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean iceofser() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 128);
    }

    public boolean iceofios() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 64);
    }

    public boolean iceofspl() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 32);
    }

    public boolean iceoforc() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 16);
    }

    public boolean iceofcvt() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 8);
    }

    public boolean iceofrep() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 4);
    }

    public boolean iceofvfl() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 2);
    }

    public boolean iceofvtr() {
        return Util.ConvertFlag(this.data, this.iceofprm(), 1);
    }

    public int iceofpr2() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public boolean iceofrmc() {
        return Util.ConvertFlag(this.data, this.iceofpr2(), 128);
    }

    public long iceofbyt() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger iceofbytAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long iceofrec() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger iceofrecAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long iceofamc() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger iceofamcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public int iceoflrl() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int iceofbkz() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String iceofddn() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String iceofnam() {
        return Util.ConvertEbcdic(this.data, 48, 44);
    }

    public String iceofvol() {
        return Util.ConvertEbcdic(this.data, 92, 6);
    }

    public long iceofbkf() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public static OutfilDatasetSection create(byte[] Data2, int offset, int length) {
        return new OutfilDatasetSection(Data2, offset, length);
    }

    static enum Field {
        iceoffl1(0, 1),
        iceofamb(1, 1),
        iceoftyp(2, 1),
        iceofrcf(3, 1),
        iceofprm(4, 1),
        iceofpr2(5, 1),
        iceofbyt(8, 8),
        iceofrec(16, 8),
        iceofamc(24, 8),
        iceoflrl(34, 2),
        iceofbkz(38, 2),
        iceofddn(40, 8),
        iceofnam(48, 44),
        iceofvol(92, 6),
        iceofbkf(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

