/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf18;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf18.Volume;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public final class Smf18Record
extends SmfRecord {
    public static final int SMF18CON = 128;
    public static final int SMF18FAC = 128;
    public static final int SMF18LNV = 8;

    public Smf18Record(byte[] data) {
        super(data);
        if (this.recordType() != 18) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf18Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 18) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf18Record from(SmfRecord record) {
        return new Smf18Record(record);
    }

    public static Smf18Record from(byte[] data) {
        return new Smf18Record(data);
    }

    public List<Volume> volumes() {
        ArrayList<Volume> result = new ArrayList<Volume>();
        for (int i = 0; i < this.smf18nvl(); ++i) {
            result.add(Volume.create(this.data, Field.smf18nvl.offset() + Field.smf18nvl.length() + i * 8, 8));
        }
        return result;
    }

    public int smf18len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf18seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf18flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf18rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf18tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf18tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf18dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf18dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf18sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf18jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf18rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf18rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf18rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf18rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf18uid() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public int smf18rin() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf18in1() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public boolean smf18con() {
        return Util.ConvertFlag(this.data, this.smf18in1(), 128);
    }

    public int smf18in2() {
        return Util.ConvertUnsignedBinary1(this.data, 43);
    }

    public String smf18ods() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public String smf18nds() {
        return Util.ConvertEbcdic(this.data, 88, 44);
    }

    public int smf18fl1() {
        return Util.ConvertUnsignedBinary1(this.data, 132);
    }

    public boolean smf18fac() {
        return Util.ConvertFlag(this.data, this.smf18fl1(), 128);
    }

    public int smf18nvl() {
        return Util.ConvertUnsignedBinary1(this.data, 135);
    }

    static enum Field {
        smf18len(0, 2),
        smf18seg(2, 2),
        smf18flg(4, 1),
        smf18rty(5, 1),
        smf18tme(6, 4),
        smf18dte(10, 4),
        smf18sid(14, 4),
        smf18jbn(18, 8),
        smf18rst(26, 4),
        smf18rsd(30, 4),
        smf18uid(34, 8),
        smf18rin(42, 2),
        smf18in1(42, 1),
        smf18in2(43, 1),
        smf18ods(44, 44),
        smf18nds(88, 44),
        smf18fl1(132, 1),
        smf18nvl(135, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

