/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf23;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf23.BindBreakInstrumentationSection;
import com.blackhillsoftware.smf.smf23.Header;
import com.blackhillsoftware.smf.smf23.LogstreamStatisticsSection;
import com.blackhillsoftware.smf.smf23.ProductSection;
import com.blackhillsoftware.smf.smf23.SmfStatisticsSection;
import com.blackhillsoftware.smf.smf23.SpinLockInstrumentationSection;
import com.blackhillsoftware.smf.smf23.SystemSection;
import java.util.List;

public class Smf23Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<SystemSection> buildSystemSection = new CreateSection<SystemSection>(){

        @Override
        public SystemSection createSection(byte[] data, int offset, int length) {
            return SystemSection.create(data, offset, length);
        }
    };
    private static final CreateSection<SmfStatisticsSection> buildSmfStatisticsSection = new CreateSection<SmfStatisticsSection>(){

        @Override
        public SmfStatisticsSection createSection(byte[] data, int offset, int length) {
            return SmfStatisticsSection.create(data, offset, length);
        }
    };
    private static final CreateSection<SpinLockInstrumentationSection> buildSpinLockInstrumentationSection = new CreateSection<SpinLockInstrumentationSection>(){

        @Override
        public SpinLockInstrumentationSection createSection(byte[] data, int offset, int length) {
            return SpinLockInstrumentationSection.create(data, offset, length);
        }
    };
    private static final CreateSection<BindBreakInstrumentationSection> buildBindBreakInstrumentationSection = new CreateSection<BindBreakInstrumentationSection>(){

        @Override
        public BindBreakInstrumentationSection createSection(byte[] data, int offset, int length) {
            return BindBreakInstrumentationSection.create(data, offset, length);
        }
    };
    private static final CreateSection<LogstreamStatisticsSection> buildLogstreamStatisticsSection = new CreateSection<LogstreamStatisticsSection>(){

        @Override
        public LogstreamStatisticsSection createSection(byte[] data, int offset, int length) {
            return LogstreamStatisticsSection.create(data, offset, length);
        }
    };
    private List<ProductSection> m_productSections = null;
    private List<SystemSection> m_systemSections = null;
    private List<SmfStatisticsSection> m_smfStatisticsSections = null;
    private List<SpinLockInstrumentationSection> m_spinLockInstrumentationSections = null;
    private List<BindBreakInstrumentationSection> m_bindBreakInstrumentationSections = null;
    private List<LogstreamStatisticsSection> m_logstreamStatisticsSections = null;
    private Header m_header = null;

    public Smf23Record(byte[] data) {
        super(data);
        if (this.recordType() != 23) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf23Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 23) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf23Record from(SmfRecord record) {
        return new Smf23Record(record);
    }

    public static Smf23Record from(byte[] data) {
        return new Smf23Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, tempHeader.smf23pof());
        }
        return this.m_header;
    }

    public List<ProductSection> productSections() {
        this.m_productSections = Util.sectionsFromTriplet(this.m_productSections, this.data, Triplets.ProductSection.getTriplet(this.header()), buildProductSection);
        return this.m_productSections;
    }

    public List<SystemSection> systemSections() {
        this.m_systemSections = Util.sectionsFromTriplet(this.m_systemSections, this.data, Triplets.SystemSection.getTriplet(this.header()), buildSystemSection);
        return this.m_systemSections;
    }

    public List<SmfStatisticsSection> smfStatisticsSections() {
        this.m_smfStatisticsSections = Util.sectionsFromTriplet(this.m_smfStatisticsSections, this.data, Triplets.SmfStatisticsSection.getTriplet(this.header()), buildSmfStatisticsSection);
        return this.m_smfStatisticsSections;
    }

    public List<SpinLockInstrumentationSection> spinLockInstrumentationSections() {
        this.m_spinLockInstrumentationSections = Util.sectionsFromTriplet(this.m_spinLockInstrumentationSections, this.data, Triplets.SpinLockInstrumentationSection.getTriplet(this.header()), buildSpinLockInstrumentationSection);
        return this.m_spinLockInstrumentationSections;
    }

    public List<BindBreakInstrumentationSection> bindBreakInstrumentationSections() {
        this.m_bindBreakInstrumentationSections = Util.sectionsFromTriplet(this.m_bindBreakInstrumentationSections, this.data, Triplets.BindBreakInstrumentationSection.getTriplet(this.header()), buildBindBreakInstrumentationSection);
        return this.m_bindBreakInstrumentationSections;
    }

    public List<LogstreamStatisticsSection> logstreamStatisticsSections() {
        this.m_logstreamStatisticsSections = Util.sectionsFromTriplet(this.m_logstreamStatisticsSections, this.data, Triplets.LogstreamStatisticsSection.getTriplet(this.header()), buildLogstreamStatisticsSection);
        return this.m_logstreamStatisticsSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf23pof(), header.smf23pln(), header.smf23pon());
            }
        }
        ,
        SystemSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf23sof(), header.smf23sln(), header.smf23son());
            }
        }
        ,
        SmfStatisticsSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf23rof(), header.smf23rln(), header.smf23ron());
            }
        }
        ,
        SpinLockInstrumentationSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf23nof(), header.smf23nln(), header.smf23non());
            }
        }
        ,
        BindBreakInstrumentationSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf23bof(), header.smf23bln(), header.smf23bon());
            }
        }
        ,
        LogstreamStatisticsSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf23lof(), header.smf23lln(), header.smf23lon());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

