/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class CompletionSection
extends SmfData {
    private String m_completiondescription = null;
    public static final int SMF30UAB = 128;
    public static final int SMF30SLC = 128;
    public static final int SMF30UJV = 64;
    public static final int SMF30UJI = 32;
    public static final int SMF30USI = 16;
    public static final int SMF30TRT = 8;
    public static final int SMF30SRS = 4;
    public static final int SMF30ABD = 2;
    public static final int SMF30FLH = 1;
    public static final int SMF30EXF = 128;
    public static final int SMF30ISK = 64;
    public static final int SMF30NEX = 32;
    public static final int SMF30SYE = 16;
    public static final int SMF30ERE = 8;
    public static final int SMF30CDE = 4;
    public static final int SMF30CNR = 2;

    private CompletionSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String completionDescription() {
        String result;
        if (this.m_completiondescription != null) {
            return this.m_completiondescription;
        }
        if (this.smf30ujv()) {
            result = "Cancelled by IEFUJV";
        } else if (this.smf30uji()) {
            result = "Cancelled by IEFUJI";
        } else if (this.smf30usi()) {
            result = "Cancelled by IEFUSI";
        } else if (this.smf30trt()) {
            result = "Cancelled by IEFACTRT";
        } else if (this.smf30flh()) {
            result = "Flushed";
        } else if (!this.smf30abd()) {
            result = Integer.toString(this.smf30scc() & 0xFFF);
        } else {
            if ((this.smf30scc() & 0x8000) != 0) {
                return "U" + String.format("%04d", this.smf30scc() & 0xFFF);
            }
            return "S" + String.format("%03X", this.smf30scc() & 0xFFF);
        }
        if (this.smf30sye()) {
            result = result + "; Post Execution Error";
        }
        this.m_completiondescription = result;
        return this.m_completiondescription;
    }

    public int smf30scc() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public boolean smf30uab() {
        return Util.ConvertFlag(this.data, this.smf30scc(), 128, Field.smf30scc.length, 0);
    }

    public int smf30sti() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf30stiByte1() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf30slc() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 128, Field.smf30sti.length, 0);
    }

    public boolean smf30ujv() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 64, Field.smf30sti.length, 0);
    }

    public boolean smf30uji() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 32, Field.smf30sti.length, 0);
    }

    public boolean smf30usi() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 16, Field.smf30sti.length, 0);
    }

    public boolean smf30trt() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 8, Field.smf30sti.length, 0);
    }

    public boolean smf30srs() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 4, Field.smf30sti.length, 0);
    }

    public boolean smf30abd() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 2, Field.smf30sti.length, 0);
    }

    public boolean smf30flh() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 1, Field.smf30sti.length, 0);
    }

    public int smf30stiByte2() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf30exf() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 128, Field.smf30sti.length, 1);
    }

    public boolean smf30isk() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 64, Field.smf30sti.length, 1);
    }

    public boolean smf30nex() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 32, Field.smf30sti.length, 1);
    }

    public boolean smf30sye() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 16, Field.smf30sti.length, 1);
    }

    public boolean smf30ere() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 8, Field.smf30sti.length, 1);
    }

    public boolean smf30cde() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 4, Field.smf30sti.length, 1);
    }

    public boolean smf30cnr() {
        return Util.ConvertFlag(this.data, this.smf30sti(), 2, Field.smf30sti.length, 1);
    }

    public long smf30arc() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public static CompletionSection create(byte[] Data2, int offset, int length) {
        return new CompletionSection(Data2, offset, length);
    }

    static enum Field {
        smf30scc(0, 2),
        smf30sti(2, 2),
        smf30stiByte1(2, 1),
        smf30stiByte2(3, 1),
        smf30arc(4, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

