/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class ExcpSection
extends SmfData {
    public static final int SMF30CBS = 128;

    private ExcpSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public BigInteger smf30key() {
        return Util.ConvertBigInteger(this.data, 0, 12);
    }

    public int smf30dev() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smf30utp() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int smf30cua() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public String smf30ddn() {
        return Util.ConvertEbcdic(this.data, 4, 8);
    }

    public long smf30blk() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int smf30bsz() {
        return Util.ConvertUnsignedBinary2(this.data, 16, Short.MAX_VALUE);
    }

    public Duration smf30dct() {
        return Util.Binary4x128US(this.data, 18);
    }

    public double smf30dctSeconds() {
        return Util.ToSeconds(this.smf30dct());
    }

    public long smf30dctRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 18);
    }

    public long smf30xbs() {
        return Util.ConvertUnsignedBinary8(this.data, 22);
    }

    public BigInteger smf30xbsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 22);
    }

    public static ExcpSection create(byte[] Data2, int offset, int length) {
        return new ExcpSection(Data2, offset, length);
    }

    static enum Field {
        smf30key(0, 12),
        smf30dev(0, 1),
        smf30utp(1, 1),
        smf30cua(2, 2),
        smf30ddn(4, 8),
        smf30blk(12, 4),
        smf30bsz(16, 2),
        smf30dct(18, 4),
        smf30xbs(22, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

