/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class IoActivitySection
extends SmfData {
    public static final int SMF30MFL = 128;
    public static final int SMF30IIN = 64;
    public static final int SMF30TEF = 32;

    private IoActivitySection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf30inp() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long smf30tep() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf30tpt() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf30tgt() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public String smf30rdr() {
        return Util.ConvertEbcdic(this.data, 16, 1);
    }

    public String smf30rdt() {
        return Util.ConvertEbcdic(this.data, 17, 1);
    }

    public Duration smf30tcn() {
        return Util.Binary4x128US(this.data, 18);
    }

    public double smf30tcnSeconds() {
        return Util.ToSeconds(this.smf30tcn());
    }

    public long smf30tcnRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 18);
    }

    public int smf30dcf() {
        return Util.ConvertUnsignedBinary1(this.data, 22);
    }

    public boolean smf30mfl() {
        return Util.ConvertFlag(this.data, this.smf30dcf(), 128);
    }

    public boolean smf30iin() {
        return Util.ConvertFlag(this.data, this.smf30dcf(), 64);
    }

    public boolean smf30tef() {
        return Util.ConvertFlag(this.data, this.smf30dcf(), 32);
    }

    public long smf30trr() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration smf30aic() {
        return Util.Binary4x128US(this.data, 32);
    }

    public double smf30aicSeconds() {
        return Util.ToSeconds(this.smf30aic());
    }

    public long smf30aicRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration smf30aid() {
        return Util.Binary4x128US(this.data, 36);
    }

    public double smf30aidSeconds() {
        return Util.ToSeconds(this.smf30aid());
    }

    public long smf30aidRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration smf30aiw() {
        return Util.Binary4x128US(this.data, 40);
    }

    public double smf30aiwSeconds() {
        return Util.ToSeconds(this.smf30aiw());
    }

    public long smf30aiwRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf30ais() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public Duration smf30eic() {
        return Util.Binary4x128US(this.data, 48);
    }

    public double smf30eicSeconds() {
        return Util.ToSeconds(this.smf30eic());
    }

    public long smf30eicRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public Duration smf30eid() {
        return Util.Binary4x128US(this.data, 52);
    }

    public double smf30eidSeconds() {
        return Util.ToSeconds(this.smf30eid());
    }

    public long smf30eidRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration smf30eiw() {
        return Util.Binary4x128US(this.data, 56);
    }

    public double smf30eiwSeconds() {
        return Util.ToSeconds(this.smf30eiw());
    }

    public long smf30eiwRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf30eis() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf30tex() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf30texAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf30das() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public static IoActivitySection create(byte[] Data2, int offset, int length) {
        return new IoActivitySection(Data2, offset, length);
    }

    static enum Field {
        smf30inp(0, 4),
        smf30tep(4, 4),
        smf30tpt(8, 4),
        smf30tgt(12, 4),
        smf30rdr(16, 1),
        smf30rdt(17, 1),
        smf30tcn(18, 4),
        smf30dcf(22, 1),
        smf30trr(28, 4),
        smf30aic(32, 4),
        smf30aid(36, 4),
        smf30aiw(40, 4),
        smf30ais(44, 4),
        smf30eic(48, 4),
        smf30eid(52, 4),
        smf30eiw(56, 4),
        smf30eis(60, 4),
        smf30tex(64, 8),
        smf30das(72, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

