/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.values.BoostClass;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;

public final class ProcessorAccountingSection
extends SmfData {
    public static final int SMF30TFO = 128;
    public static final int SMF30CTF = 64;
    public static final int SMF30CSF = 32;
    public static final int SMF30VUF = 16;
    public static final int SMF30VAF = 8;
    public static final int SMF30ISF = 4;
    public static final int SMF30ICF = 2;
    public static final int SMF30IVF = 1;
    public static final int SMF30IAF = 128;
    public static final int SMF30IIF = 64;
    public static final int SMF30HPF = 32;
    public static final int SMF30RCF = 16;
    public static final int SMF30ASF = 8;
    public static final int SMF30ENF = 4;
    public static final int SMF30DEF = 2;
    public static final int SMF30CIN = 1;
    public static final int SMF30_TIME_ON_zCBP_F = 128;
    public static final int SMF30_TIME_ON_IFA_F = 128;
    public static final int SMF30_ENCLAVE_TIME_ON_zCBP_F = 64;
    public static final int SMF30_ENCLAVE_TIME_ON_IFA_F = 64;
    public static final int SMF30_DEP_ENCLAVE_TIME_ON_zCBP_F = 32;
    public static final int SMF30_DEP_ENCLAVE_TIME_ON_IFA_F = 32;
    public static final int SMF30_TIME_zCBP_ON_CP_F = 16;
    public static final int SMF30_TIME_IFA_ON_CP_F = 16;
    public static final int SMF30_ENCLAVE_TIME_zCBP_ON_CP_F = 8;
    public static final int SMF30_ENCLAVE_TIME_IFA_ON_CP_F = 8;
    public static final int SMF30_DEP_ENCLAVE_TIME_zCBP_ON_CP_F = 4;
    public static final int SMF30_DEP_ENCLAVE_TIME_IFA_ON_CP_F = 4;
    public static final int SMF30_CEPI_F = 2;
    public static final int SMF30CRP_F = 1;
    public static final int SMF30_TIME_ON_zIIP_F = 128;
    public static final int SMF30_TIME_ON_SUP_F = 128;
    public static final int SMF30_ENCLAVE_TIME_ON_zIIP_F = 64;
    public static final int SMF30_ENCLAVE_TIME_ON_SUP_F = 64;
    public static final int SMF30_DEPENC_TIME_ON_zIIP_F = 32;
    public static final int SMF30_DEPENC_TIME_ON_SUP_F = 32;
    public static final int SMF30_TIME_zIIP_ON_CP_F = 16;
    public static final int SMF30_TIME_SUP_ON_CP_F = 16;
    public static final int SMF30_ENCLAVE_TIME_zIIP_ON_CP_F = 8;
    public static final int SMF30_ENCLAVE_TIME_SUP_ON_CP_F = 8;
    public static final int SMF30_DEPENC_TIME_zIIP_ON_CP_F = 4;
    public static final int SMF30_DEPENC_TIME_SUP_ON_CP_F = 4;
    public static final int SMF30_Time_Java_On_zIIP_F = 2;
    public static final int SMF30_ENCLAVE_Time_Java_On_zIIP_F = 1;
    public static final int SMF30_ENCLAVE_TIME_ON_zIIP_N_F = 128;
    public static final int SMF30_ENCLAVE_TIME_ON_SUP_N_F = 128;
    public static final int SMF30_DEPENC_TIME_ON_zIIP_N_F = 64;
    public static final int SMF30_DEPENC_TIME_ON_SUP_N_F = 64;
    public static final int SMF30_ENCLAVE_TIME_zIIP_QUAL_F = 32;
    public static final int SMF30_ENCLAVE_TIME_SUP_QUAL_F = 32;
    public static final int SMF30_DEPENC_TIME_zIIP_QUAL_F = 16;
    public static final int SMF30_DEPENC_TIME_SUP_QUAL_F = 16;
    public static final int SMF30_DEPENC_Time_Java_On_zIIP_F = 8;
    public static final int SMF30_Time_Java_On_CP_F = 4;
    public static final int SMF30_ENCLAVE_Time_Java_On_CP_F = 2;
    public static final int SMF30_DEPENC_Time_Java_On_CP_F = 1;
    public static final int SMF30_zIIPBoost_Active = 128;
    public static final int SMF30_SpeedBoost_Active = 64;
    public static final int SMF30_BoostClass = 7;
    public static final int SMF30_BoostClass_Mask = 7;
    public static final int SMF30CAS_InEligHonorPriority = 128;
    public static final int SMF30CAS_Len_V1 = 192;
    public static final int SMF30CAS_Len_V2 = 216;

    private ProcessorAccountingSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf30pty() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf30tfl() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf30tflByte1() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf30tfo() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 128);
    }

    public boolean smf30ctf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 64);
    }

    public boolean smf30csf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 32);
    }

    public boolean smf30vuf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 16);
    }

    public boolean smf30vaf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 8);
    }

    public boolean smf30isf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 4);
    }

    public boolean smf30icf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 2);
    }

    public boolean smf30ivf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte1(), 1);
    }

    public int smf30tflByte2() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf30iaf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 128);
    }

    public boolean smf30iif() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 64);
    }

    public boolean smf30hpf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 32);
    }

    public boolean smf30rcf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 16);
    }

    public boolean smf30asf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 8);
    }

    public boolean smf30enf() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 4);
    }

    public boolean smf30def() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 2);
    }

    public boolean smf30cin() {
        return Util.ConvertFlag(this.data, this.smf30tflByte2(), 1);
    }

    public Duration smf30cpt() {
        return Util.Binary4x100S(this.data, 4);
    }

    public double smf30cptSeconds() {
        return Util.ToSeconds(this.smf30cpt());
    }

    public long smf30cptRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public Duration smf30cps() {
        return Util.Binary4x100S(this.data, 8);
    }

    public double smf30cpsSeconds() {
        return Util.ToSeconds(this.smf30cps());
    }

    public long smf30cpsRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public Duration smf30icu() {
        return Util.Binary4x100S(this.data, 12);
    }

    public double smf30icuSeconds() {
        return Util.ToSeconds(this.smf30icu());
    }

    public long smf30icuRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public Duration smf30isb() {
        return Util.Binary4x100S(this.data, 16);
    }

    public double smf30isbSeconds() {
        return Util.ToSeconds(this.smf30isb());
    }

    public long smf30isbRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public Duration smf30jvu() {
        return Util.Binary4x100S(this.data, 20);
    }

    public double smf30jvuSeconds() {
        return Util.ToSeconds(this.smf30jvu());
    }

    public long smf30jvuRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public Duration smf30ivu() {
        return Util.Binary4x100S(this.data, 24);
    }

    public double smf30ivuSeconds() {
        return Util.ToSeconds(this.smf30ivu());
    }

    public long smf30ivuRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public Duration smf30jva() {
        return Util.Binary4x100S(this.data, 28);
    }

    public double smf30jvaSeconds() {
        return Util.ToSeconds(this.smf30jva());
    }

    public long smf30jvaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration smf30iva() {
        return Util.Binary4x100S(this.data, 32);
    }

    public double smf30ivaSeconds() {
        return Util.ToSeconds(this.smf30iva());
    }

    public long smf30ivaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public LocalTime smf30ist() {
        return Util.Binary4x100STime(this.data, 36);
    }

    public long smf30istRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public LocalDate smf30idt() {
        return Util.SMFDate(this.data, 40);
    }

    public int smf30idtRawValue() {
        return Util.ConvertPacked4(this.data, 40);
    }

    public Duration smf30iip() {
        return Util.Binary4x100S(this.data, 44);
    }

    public double smf30iipSeconds() {
        return Util.ToSeconds(this.smf30iip());
    }

    public long smf30iipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public Duration smf30rct() {
        return Util.Binary4x100S(this.data, 48);
    }

    public double smf30rctSeconds() {
        return Util.ToSeconds(this.smf30rct());
    }

    public long smf30rctRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public Duration smf30hpt() {
        return Util.Binary4x100S(this.data, 52);
    }

    public double smf30hptSeconds() {
        return Util.ToSeconds(this.smf30hpt());
    }

    public long smf30hptRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf30csc() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf30dmi() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf30dmo() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public Duration smf30asr() {
        return Util.Binary4x100S(this.data, 68);
    }

    public double smf30asrSeconds() {
        return Util.ToSeconds(this.smf30asr());
    }

    public long smf30asrRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public Duration smf30enc() {
        return Util.Binary4x100S(this.data, 72);
    }

    public double smf30encSeconds() {
        return Util.ToSeconds(this.smf30enc());
    }

    public long smf30encRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public Duration smf30det() {
        return Util.Binary4x100S(this.data, 76);
    }

    public double smf30detSeconds() {
        return Util.ToSeconds(this.smf30det());
    }

    public long smf30detRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public Duration smf30cep() {
        return Util.Binary4x1024MS(this.data, 80);
    }

    public double smf30cepSeconds() {
        return Util.ToSeconds(this.smf30cep());
    }

    public long smf30cepRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public int smf30tf2() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    public boolean smf30TimeOnZcbpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 128);
    }

    public boolean smf30TimeOnIfaF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 128);
    }

    public boolean smf30EnclaveTimeOnZcbpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 64);
    }

    public boolean smf30EnclaveTimeOnIfaF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 64);
    }

    public boolean smf30DepEnclaveTimeOnZcbpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 32);
    }

    public boolean smf30DepEnclaveTimeOnIfaF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 32);
    }

    public boolean smf30TimeZcbpOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 16);
    }

    public boolean smf30TimeIfaOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 16);
    }

    public boolean smf30EnclaveTimeZcbpOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 8);
    }

    public boolean smf30EnclaveTimeIfaOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 8);
    }

    public boolean smf30DepEnclaveTimeZcbpOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 4);
    }

    public boolean smf30DepEnclaveTimeIfaOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 4);
    }

    public boolean smf30CepiF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 2);
    }

    public boolean smf30crpF() {
        return Util.ConvertFlag(this.data, this.smf30tf2(), 1);
    }

    public int smf30t32() {
        return Util.ConvertUnsignedBinary1(this.data, 85);
    }

    public boolean smf30TimeOnZiipF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 128);
    }

    public boolean smf30TimeOnSupF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 128);
    }

    public boolean smf30EnclaveTimeOnZiipF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 64);
    }

    public boolean smf30EnclaveTimeOnSupF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 64);
    }

    public boolean smf30DepEncTimeOnZiipF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 32);
    }

    public boolean smf30DepEncTimeOnSupF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 32);
    }

    public boolean smf30TimeZiipOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 16);
    }

    public boolean smf30TimeSupOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 16);
    }

    public boolean smf30EnclaveTimeZiipOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 8);
    }

    public boolean smf30EnclaveTimeSupOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 8);
    }

    public boolean smf30DepEncTimeZiipOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 4);
    }

    public boolean smf30DepEncTimeSupOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 4);
    }

    public boolean smf30TimeJavaOnZiipF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 2);
    }

    public boolean smf30EnclaveTimeJavaOnZiipF() {
        return Util.ConvertFlag(this.data, this.smf30t32(), 1);
    }

    public int smf30t33() {
        return Util.ConvertUnsignedBinary1(this.data, 86);
    }

    public boolean smf30EnclaveTimeOnZiipNF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 128);
    }

    public boolean smf30EnclaveTimeOnSupNF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 128);
    }

    public boolean smf30DepEncTimeOnZiipNF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 64);
    }

    public boolean smf30DepEncTimeOnSupNF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 64);
    }

    public boolean smf30EnclaveTimeZiipQualF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 32);
    }

    public boolean smf30EnclaveTimeSupQualF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 32);
    }

    public boolean smf30DepEncTimeZiipQualF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 16);
    }

    public boolean smf30DepEncTimeSupQualF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 16);
    }

    public boolean smf30DepEncTimeJavaOnZiipF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 8);
    }

    public boolean smf30TimeJavaOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 4);
    }

    public boolean smf30EnclaveTimeJavaOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 2);
    }

    public boolean smf30DepEncTimeJavaOnCpF() {
        return Util.ConvertFlag(this.data, this.smf30t33(), 1);
    }

    public int smf30BoostInfo() {
        return Util.ConvertUnsignedBinary1(this.data, 87);
    }

    public int smf30Bi() {
        return Util.ConvertUnsignedBinary1(this.data, 87);
    }

    public boolean smf30ZiipBoostActive() {
        return Util.ConvertFlag(this.data, this.smf30BoostInfo(), 128);
    }

    public boolean smf30SpeedBoostActive() {
        return Util.ConvertFlag(this.data, this.smf30BoostInfo(), 64);
    }

    public BoostClass smf30BoostClass() {
        if (this.smf30ZiipBoostActive() || this.smf30SpeedBoostActive()) {
            return BoostClass.from(this.smf30BoostInfo() & 7);
        }
        return null;
    }

    public Duration smf30TimeOnZcbp() {
        return Util.Binary4x100S(this.data, 88);
    }

    public double smf30TimeOnZcbpSeconds() {
        return Util.ToSeconds(this.smf30TimeOnZcbp());
    }

    public long smf30TimeOnZcbpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public Duration smf30TimeOnIfa() {
        return Util.Binary4x100S(this.data, 88);
    }

    public double smf30TimeOnIfaSeconds() {
        return Util.ToSeconds(this.smf30TimeOnIfa());
    }

    public long smf30TimeOnIfaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public Duration smf30EnclaveTimeOnZcbp() {
        return Util.Binary4x100S(this.data, 92);
    }

    public double smf30EnclaveTimeOnZcbpSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeOnZcbp());
    }

    public long smf30EnclaveTimeOnZcbpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public Duration smf30EnclaveTimeOnIfa() {
        return Util.Binary4x100S(this.data, 92);
    }

    public double smf30EnclaveTimeOnIfaSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeOnIfa());
    }

    public long smf30EnclaveTimeOnIfaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public Duration smf30DepEnclaveTimeOnZcbp() {
        return Util.Binary4x100S(this.data, 96);
    }

    public double smf30DepEnclaveTimeOnZcbpSeconds() {
        return Util.ToSeconds(this.smf30DepEnclaveTimeOnZcbp());
    }

    public long smf30DepEnclaveTimeOnZcbpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public Duration smf30DepEnclaveTimeOnIfa() {
        return Util.Binary4x100S(this.data, 96);
    }

    public double smf30DepEnclaveTimeOnIfaSeconds() {
        return Util.ToSeconds(this.smf30DepEnclaveTimeOnIfa());
    }

    public long smf30DepEnclaveTimeOnIfaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public Duration smf30TimeZcbpOnCp() {
        return Util.Binary4x100S(this.data, 100);
    }

    public double smf30TimeZcbpOnCpSeconds() {
        return Util.ToSeconds(this.smf30TimeZcbpOnCp());
    }

    public long smf30TimeZcbpOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public Duration smf30TimeIfaOnCp() {
        return Util.Binary4x100S(this.data, 100);
    }

    public double smf30TimeIfaOnCpSeconds() {
        return Util.ToSeconds(this.smf30TimeIfaOnCp());
    }

    public long smf30TimeIfaOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public Duration smf30EnclaveTimeZcbpOnCp() {
        return Util.Binary4x100S(this.data, 104);
    }

    public double smf30EnclaveTimeZcbpOnCpSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeZcbpOnCp());
    }

    public long smf30EnclaveTimeZcbpOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration smf30EnclaveTimeIfaOnCp() {
        return Util.Binary4x100S(this.data, 104);
    }

    public double smf30EnclaveTimeIfaOnCpSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeIfaOnCp());
    }

    public long smf30EnclaveTimeIfaOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration smf30DepEnclaveTimeZcbpOnCp() {
        return Util.Binary4x100S(this.data, 108);
    }

    public double smf30DepEnclaveTimeZcbpOnCpSeconds() {
        return Util.ToSeconds(this.smf30DepEnclaveTimeZcbpOnCp());
    }

    public long smf30DepEnclaveTimeZcbpOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public Duration smf30DepEnclaveTimeIfaOnCp() {
        return Util.Binary4x100S(this.data, 108);
    }

    public double smf30DepEnclaveTimeIfaOnCpSeconds() {
        return Util.ToSeconds(this.smf30DepEnclaveTimeIfaOnCp());
    }

    public long smf30DepEnclaveTimeIfaOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public Duration smf30cepi() {
        return Util.Binary4x1024MS(this.data, 112);
    }

    public double smf30cepiSeconds() {
        return Util.ToSeconds(this.smf30cepi());
    }

    public long smf30cepiRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public Duration smf30TimeOnZiip() {
        return Util.Binary4x100S(this.data, 116);
    }

    public double smf30TimeOnZiipSeconds() {
        return Util.ToSeconds(this.smf30TimeOnZiip());
    }

    public long smf30TimeOnZiipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public Duration smf30TimeOnSup() {
        return Util.Binary4x100S(this.data, 116);
    }

    public double smf30TimeOnSupSeconds() {
        return Util.ToSeconds(this.smf30TimeOnSup());
    }

    public long smf30TimeOnSupRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public Duration smf30EnclaveTimeOnZiip() {
        return Util.Binary4x100S(this.data, 120);
    }

    public double smf30EnclaveTimeOnZiipSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeOnZiip());
    }

    public long smf30EnclaveTimeOnZiipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public Duration smf30EnclaveTimeOnSup() {
        return Util.Binary4x100S(this.data, 120);
    }

    public double smf30EnclaveTimeOnSupSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeOnSup());
    }

    public long smf30EnclaveTimeOnSupRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public Duration smf30DepencTimeOnZiip() {
        return Util.Binary4x100S(this.data, 124);
    }

    public double smf30DepencTimeOnZiipSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeOnZiip());
    }

    public long smf30DepencTimeOnZiipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public Duration smf30DepencTimeOnSup() {
        return Util.Binary4x100S(this.data, 124);
    }

    public double smf30DepencTimeOnSupSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeOnSup());
    }

    public long smf30DepencTimeOnSupRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public Duration smf30TimeZiipOnCp() {
        return Util.Binary4x100S(this.data, 128);
    }

    public double smf30TimeZiipOnCpSeconds() {
        return Util.ToSeconds(this.smf30TimeZiipOnCp());
    }

    public long smf30TimeZiipOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public Duration smf30TimeSupOnCp() {
        return Util.Binary4x100S(this.data, 128);
    }

    public double smf30TimeSupOnCpSeconds() {
        return Util.ToSeconds(this.smf30TimeSupOnCp());
    }

    public long smf30TimeSupOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public Duration smf30EnclaveTimeZiipOnCp() {
        return Util.Binary4x100S(this.data, 132);
    }

    public double smf30EnclaveTimeZiipOnCpSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeZiipOnCp());
    }

    public long smf30EnclaveTimeZiipOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public Duration smf30EnclaveTimeSupOnCp() {
        return Util.Binary4x100S(this.data, 132);
    }

    public double smf30EnclaveTimeSupOnCpSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeSupOnCp());
    }

    public long smf30EnclaveTimeSupOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public Duration smf30DepencTimeZiipOnCp() {
        return Util.Binary4x100S(this.data, 136);
    }

    public double smf30DepencTimeZiipOnCpSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeZiipOnCp());
    }

    public long smf30DepencTimeZiipOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public Duration smf30DepencTimeSupOnCp() {
        return Util.Binary4x100S(this.data, 136);
    }

    public double smf30DepencTimeSupOnCpSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeSupOnCp());
    }

    public long smf30DepencTimeSupOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public Duration smf30EnclaveTimeZiipQual() {
        return Util.Binary4x100S(this.data, 140);
    }

    public double smf30EnclaveTimeZiipQualSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeZiipQual());
    }

    public long smf30EnclaveTimeZiipQualRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public Duration smf30EnclaveTimeSupQual() {
        return Util.Binary4x100S(this.data, 140);
    }

    public double smf30EnclaveTimeSupQualSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeSupQual());
    }

    public long smf30EnclaveTimeSupQualRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public Duration smf30DepencTimeZiipQual() {
        return Util.Binary4x100S(this.data, 144);
    }

    public double smf30DepencTimeZiipQualSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeZiipQual());
    }

    public long smf30DepencTimeZiipQualRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public Duration smf30DepencTimeSupQual() {
        return Util.Binary4x100S(this.data, 144);
    }

    public double smf30DepencTimeSupQualSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeSupQual());
    }

    public long smf30DepencTimeSupQualRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public Duration smf30crp() {
        return Util.Binary4x1024MS(this.data, 148);
    }

    public double smf30crpSeconds() {
        return Util.ToSeconds(this.smf30crp());
    }

    public long smf30crpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public Duration smf30icuStepTerm() {
        return Util.Binary4x100S(this.data, 152);
    }

    public double smf30icuStepTermSeconds() {
        return Util.ToSeconds(this.smf30icuStepTerm());
    }

    public long smf30icuStepTermRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public Duration smf30icuStepInit() {
        return Util.Binary4x100S(this.data, 156);
    }

    public double smf30icuStepInitSeconds() {
        return Util.ToSeconds(this.smf30icuStepInit());
    }

    public long smf30icuStepInitRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public Duration smf30isbStepTerm() {
        return Util.Binary4x100S(this.data, 160);
    }

    public double smf30isbStepTermSeconds() {
        return Util.ToSeconds(this.smf30isbStepTerm());
    }

    public long smf30isbStepTermRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public Duration smf30isbStepInit() {
        return Util.Binary4x100S(this.data, 164);
    }

    public double smf30isbStepInitSeconds() {
        return Util.ToSeconds(this.smf30isbStepInit());
    }

    public long smf30isbStepInitRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long smf30MissedSmf30blk() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long smf30MissedSmf30dct() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public int smf30HighestTaskCpuPercent() {
        return Util.ConvertUnsignedBinary2(this.data, 176);
    }

    public String smf30HighestTaskCpuProgram() {
        return Util.ConvertEbcdic(this.data, 178, 8);
    }

    public int smf30casFlag() {
        return Util.ConvertUnsignedBinary1(this.data, 186);
    }

    public boolean smf30casInEligHonorPriority() {
        return Util.ConvertFlag(this.data, this.smf30casFlag(), 128);
    }

    @Deprecated
    public boolean smf30casInelighonorpriority() {
        return Util.ConvertFlag(this.data, this.smf30casFlag(), 128);
    }

    public byte[] smf30casOa54589() {
        if (this.data.length >= 192) {
            byte[] result = new byte[4];
            System.arraycopy(this.data, 188, result, 0, 4);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(188) + " Data length: " + Integer.toString(4));
    }

    public Duration smf30TimeJavaOnZiip() {
        return Util.Binary4x100S(this.data, 192);
    }

    public double smf30TimeJavaOnZiipSeconds() {
        return Util.ToSeconds(this.smf30TimeJavaOnZiip());
    }

    public long smf30TimeJavaOnZiipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public Duration smf30EnclaveTimeJavaOnZiip() {
        return Util.Binary4x100S(this.data, 196);
    }

    public double smf30EnclaveTimeJavaOnZiipSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeJavaOnZiip());
    }

    public long smf30EnclaveTimeJavaOnZiipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public Duration smf30DepEncTimeJavaOnZiip() {
        return Util.Binary4x100S(this.data, 200);
    }

    public double smf30DepEncTimeJavaOnZiipSeconds() {
        return Util.ToSeconds(this.smf30DepEncTimeJavaOnZiip());
    }

    public long smf30DepEncTimeJavaOnZiipRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public Duration smf30TimeJavaOnCp() {
        return Util.Binary4x100S(this.data, 204);
    }

    public double smf30TimeJavaOnCpSeconds() {
        return Util.ToSeconds(this.smf30TimeJavaOnCp());
    }

    public long smf30TimeJavaOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public Duration smf30EnclaveTimeJavaOnCp() {
        return Util.Binary4x100S(this.data, 208);
    }

    public double smf30EnclaveTimeJavaOnCpSeconds() {
        return Util.ToSeconds(this.smf30EnclaveTimeJavaOnCp());
    }

    public long smf30EnclaveTimeJavaOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public Duration smf30DepencTimeJavaOnCp() {
        return Util.Binary4x100S(this.data, 212);
    }

    public double smf30DepencTimeJavaOnCpSeconds() {
        return Util.ToSeconds(this.smf30DepencTimeJavaOnCp());
    }

    public long smf30DepencTimeJavaOnCpRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public static ProcessorAccountingSection create(byte[] Data2, int offset, int length) {
        return new ProcessorAccountingSection(Data2, offset, length);
    }

    static enum Field {
        smf30pty(0, 2),
        smf30tfl(2, 2),
        smf30tflByte1(2, 1),
        smf30tflByte2(3, 1),
        smf30cpt(4, 4),
        smf30cps(8, 4),
        smf30icu(12, 4),
        smf30isb(16, 4),
        smf30jvu(20, 4),
        smf30ivu(24, 4),
        smf30jva(28, 4),
        smf30iva(32, 4),
        smf30ist(36, 4),
        smf30idt(40, 4),
        smf30iip(44, 4),
        smf30rct(48, 4),
        smf30hpt(52, 4),
        smf30csc(56, 4),
        smf30dmi(60, 4),
        smf30dmo(64, 4),
        smf30asr(68, 4),
        smf30enc(72, 4),
        smf30det(76, 4),
        smf30cep(80, 4),
        smf30tf2(84, 1),
        smf30t32(85, 1),
        smf30t33(86, 1),
        smf30BoostInfo(87, 1),
        smf30Bi(87, 1),
        smf30TimeOnZcbp(88, 4),
        smf30TimeOnIfa(88, 4),
        smf30EnclaveTimeOnZcbp(92, 4),
        smf30EnclaveTimeOnIfa(92, 4),
        smf30DepEnclaveTimeOnZcbp(96, 4),
        smf30DepEnclaveTimeOnIfa(96, 4),
        smf30TimeZcbpOnCp(100, 4),
        smf30TimeIfaOnCp(100, 4),
        smf30EnclaveTimeZcbpOnCp(104, 4),
        smf30EnclaveTimeIfaOnCp(104, 4),
        smf30DepEnclaveTimeZcbpOnCp(108, 4),
        smf30DepEnclaveTimeIfaOnCp(108, 4),
        smf30cepi(112, 4),
        smf30TimeOnZiip(116, 4),
        smf30TimeOnSup(116, 4),
        smf30EnclaveTimeOnZiip(120, 4),
        smf30EnclaveTimeOnSup(120, 4),
        smf30DepencTimeOnZiip(124, 4),
        smf30DepencTimeOnSup(124, 4),
        smf30TimeZiipOnCp(128, 4),
        smf30TimeSupOnCp(128, 4),
        smf30EnclaveTimeZiipOnCp(132, 4),
        smf30EnclaveTimeSupOnCp(132, 4),
        smf30DepencTimeZiipOnCp(136, 4),
        smf30DepencTimeSupOnCp(136, 4),
        smf30EnclaveTimeZiipQual(140, 4),
        smf30EnclaveTimeSupQual(140, 4),
        smf30DepencTimeZiipQual(144, 4),
        smf30DepencTimeSupQual(144, 4),
        smf30crp(148, 4),
        smf30icuStepTerm(152, 4),
        smf30icuStepInit(156, 4),
        smf30isbStepTerm(160, 4),
        smf30isbStepInit(164, 4),
        smf30MissedSmf30blk(168, 4),
        smf30MissedSmf30dct(172, 4),
        smf30HighestTaskCpuPercent(176, 2),
        smf30HighestTaskCpuProgram(178, 8),
        smf30casFlag(186, 1),
        smf30casOa54589(188, 4),
        smf30TimeJavaOnZiip(192, 4),
        smf30EnclaveTimeJavaOnZiip(196, 4),
        smf30DepEncTimeJavaOnZiip(200, 4),
        smf30TimeJavaOnCp(204, 4),
        smf30EnclaveTimeJavaOnCp(208, 4),
        smf30DepencTimeJavaOnCp(212, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

