/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF42FSI = 128;
    public static final int SMF42FSU = 64;
    public static final int SMF42FXA = 4;
    public static final int SMF42FS2 = 2;
    public static final int SMF42FS1 = 1;
    public static final int SMF42_LEN = 36;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf42rcl() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf42sgd() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf42flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf42fsi() {
        return Util.ConvertFlag(this.data, this.smf42flg(), 128);
    }

    public boolean smf42fsu() {
        return Util.ConvertFlag(this.data, this.smf42flg(), 64);
    }

    public boolean smf42fxa() {
        return Util.ConvertFlag(this.data, this.smf42flg(), 4);
    }

    public boolean smf42fs2() {
        return Util.ConvertFlag(this.data, this.smf42flg(), 2);
    }

    public boolean smf42fs1() {
        return Util.ConvertFlag(this.data, this.smf42flg(), 1);
    }

    public int smf42rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf42tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf42tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf42dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf42dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf42sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf42ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf42sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf42nt() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf42ops() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf42lps() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf42nps() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf42rcl(0, 2),
        smf42sgd(2, 2),
        smf42flg(4, 1),
        smf42rty(5, 1),
        smf42tme(6, 4),
        smf42dte(10, 4),
        smf42sid(14, 4),
        smf42ssi(18, 4),
        smf42sty(22, 2),
        smf42nt(24, 2),
        smf42ops(28, 4),
        smf42lps(32, 2),
        smf42nps(34, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

