/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype23;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public final class RmmSecurity
extends SmfData {
    public static final int SMF420NA_LEN = 114;

    private RmmSecurity(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf42njbn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public LocalTime smf42nrst() {
        return Util.Binary4x100STime(this.data, 8);
    }

    public long smf42nrstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public LocalDate smf42nrsd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf42nrsdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public String smf42nuif() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf42nuid() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String smf42ncgp() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf42nver() {
        return Util.ConvertEbcdic(this.data, 40, 1);
    }

    public String smf42nact() {
        return Util.ConvertEbcdic(this.data, 41, 1);
    }

    public int smf42nstp() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public String smf42ndsn() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public String smf42nvol() {
        return Util.ConvertEbcdic(this.data, 88, 6);
    }

    public String smf42nunt() {
        return Util.ConvertEbcdic(this.data, 94, 8);
    }

    public int smf42ndsq() {
        return Util.ConvertUnsignedBinary2(this.data, 102);
    }

    public int smf42nvsq() {
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public ZoneOffset smf42nldto() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 106);
    }

    public long smf42nldtoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 106);
    }

    public String smf42nend() {
        return Util.ConvertEbcdic(this.data, 114, 1);
    }

    public static RmmSecurity create(byte[] Data2, int offset, int length) {
        return new RmmSecurity(Data2, offset, length);
    }

    static enum Field {
        smf42njbn(0, 8),
        smf42nrst(8, 4),
        smf42nrsd(12, 4),
        smf42nuif(16, 8),
        smf42nuid(24, 8),
        smf42ncgp(32, 8),
        smf42nver(40, 1),
        smf42nact(41, 1),
        smf42nstp(42, 1),
        smf42ndsn(44, 44),
        smf42nvol(88, 6),
        smf42nunt(94, 8),
        smf42ndsq(102, 2),
        smf42nvsq(104, 2),
        smf42nldto(106, 8),
        smf42nend(114, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

