/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype4;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf42.subtype4.EavConcurrentCopySsidHeader;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.List;

public final class EavConcurrentCopySessionStatistics
extends SmfData {
    public static final int SMF4204V_LEN = 88;
    private List<EavConcurrentCopySsidHeader> m_eavConcurrentCopySsidHeader = null;

    private EavConcurrentCopySessionStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long s42vcid() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String s42vcrqs() {
        return Util.ConvertEbcdic(this.data, 4, 3);
    }

    public String s42vcts() {
        return Util.ConvertEbcdic(this.data, 7, 1);
    }

    public String s42vcjnm() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String s42vcjno() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public ZonedDateTime s42vcsst() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger s42vcsstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public ZonedDateTime s42vceit() {
        return Util.Binary8xStckTime(this.data, 32);
    }

    public BigInteger s42vceitRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public ZonedDateTime s42vcset() {
        return Util.Binary8xStckTime(this.data, 40);
    }

    public BigInteger s42vcsetRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long s42vcctk() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger s42vcctkAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long s42vcvtk() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger s42vcvtkAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long s42vcdsp() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger s42vcdspAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public int s42vcsso() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    public int s42vcssn() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int s42vcssl() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public List<EavConcurrentCopySsidHeader> EavConcurrentCopySsidHeaders() {
        this.m_eavConcurrentCopySsidHeader = Util.sectionsFromTriplet(this.m_eavConcurrentCopySsidHeader, this.data, () -> this.s42vcsso(), () -> this.s42vcssl(), () -> this.s42vcssn(), EavConcurrentCopySsidHeader::create);
        return this.m_eavConcurrentCopySsidHeader;
    }

    public static EavConcurrentCopySessionStatistics create(byte[] Data2, int offset, int length) {
        return new EavConcurrentCopySessionStatistics(Data2, offset, length);
    }

    static enum Field {
        s42vcid(0, 4),
        s42vcrqs(4, 3),
        s42vcts(7, 1),
        s42vcjnm(8, 8),
        s42vcjno(16, 8),
        s42vcsst(24, 8),
        s42vceit(32, 8),
        s42vcset(40, 8),
        s42vcctk(48, 8),
        s42vcvtk(56, 8),
        s42vcdsp(64, 8),
        s42vcsso(72, 4),
        s42vcssn(76, 2),
        s42vcssl(78, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

