/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype6;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf42.subtype6.DatasetHeader;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;

public final class JobHeader
extends SmfData {
    private List<DatasetHeader> m_DatasetHeader = new ArrayList<DatasetHeader>();

    private JobHeader(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        if (this.s42jddso() != 0) {
            DatasetHeader current = DatasetHeader.create(Data2, this.s42jddso(), this.s42jddsl(), this.s42jdiol(), this.s42jdaml());
            this.m_DatasetHeader.add(current);
            while (current.s42dsnxt() != 0) {
                current = DatasetHeader.create(Data2, current.s42dsnxt(), this.s42jddsl(), this.s42jdiol(), this.s42jdaml());
                this.m_DatasetHeader.add(current);
            }
        }
    }

    public String s42jdjnm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public LocalTime s42jdrst() {
        return Util.Binary4x100STime(this.data, 8);
    }

    public long s42jdrstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public LocalDate s42jdrsd() {
        return Util.SMFDate(this.data, 12);
    }

    public int s42jdrsdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public String s42jduid() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public int s42jddso() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int s42jddsl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int s42jdcod() {
        return Util.ConvertUnsignedBinary1(this.data, 30);
    }

    public int s42jdver() {
        return Util.ConvertUnsignedBinary1(this.data, 31);
    }

    public int s42jdpgn() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int s42jdiol() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int s42jdaml() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int s42jdst1() {
        return Util.ConvertUnsignedBinary1(this.data, 38);
    }

    public ZoneOffset s42jdgmo() {
        return Util.Binary4_CVTTZ(this.data, 40);
    }

    public int s42jdgmoRawValue() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    public String s42jdwsc() {
        return Util.ConvertEbcdic(this.data, 44, 8);
    }

    public String s42jdwld() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    public String s42jdstn() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public List<DatasetHeader> datasetHeaders() {
        return this.m_DatasetHeader;
    }

    public static JobHeader create(byte[] Data2, int offset, int length) {
        return new JobHeader(Data2, offset, length);
    }

    static enum Field {
        s42jdjnm(0, 8),
        s42jdrst(8, 4),
        s42jdrsd(12, 4),
        s42jduid(16, 8),
        s42jddso(24, 4),
        s42jddsl(28, 2),
        s42jdcod(30, 1),
        s42jdver(31, 1),
        s42jdpgn(32, 2),
        s42jdiol(34, 2),
        s42jdaml(36, 2),
        s42jdst1(38, 1),
        s42jdgmo(40, 4),
        s42jdwsc(44, 8),
        s42jdwld(52, 8),
        s42jdstn(64, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

