/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf6;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class EssSection
extends SmfData {
    public static final int SMF6SJF = 128;

    private EssSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf6ln5() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public long smf6sgid() {
        return Util.ConvertUnsignedBinary4(this.data, 2);
    }

    public int smf6ind() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public boolean smf6sjf() {
        return Util.ConvertFlag(this.data, this.smf6ind(), 128);
    }

    public int smf6rsv() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public String smf6jdvt() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public int smf6tul() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public byte[] smf6tu() {
        if (this.data.length >= 18 + this.smf6tul()) {
            byte[] result = new byte[this.smf6tul()];
            System.arraycopy(this.data, 18, result, 0, this.smf6tul());
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(18) + " Data length: " + Integer.toString(this.smf6tul()));
    }

    public static EssSection create(byte[] Data2, int offset, int length) {
        return new EssSection(Data2, offset, length);
    }

    static enum Field {
        smf6ln5(0, 2),
        smf6sgid(2, 4),
        smf6ind(6, 1),
        smf6rsv(7, 1),
        smf6jdvt(8, 8),
        smf6tul(16, 2),
        smf6tu(18, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

