/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf6;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf6.ApaPrintingSection;
import com.blackhillsoftware.smf.smf6.CommonSection;
import com.blackhillsoftware.smf.smf6.EssSection;
import com.blackhillsoftware.smf.smf6.FileTransferSection;
import com.blackhillsoftware.smf.smf6.IoDataSection;
import com.blackhillsoftware.smf.smf6.NonImpactPrintingSection;
import com.blackhillsoftware.smf.smf6.Smf6Subsystem;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf6Record
extends SmfRecord {
    private IoDataSection m_ioDataSection = null;
    private NonImpactPrintingSection m_nonImpactPrintingSubsystemSection = null;
    private CommonSection m_commonSection = null;
    private ApaPrintingSection m_apaSubsystemSection = null;
    private EssSection m_enhancedSysoutSection = null;
    private FileTransferSection m_fileTransferSection = null;
    public static final int SMFRCD6 = 0;
    public static final int SMFJ6 = 6;
    public static final int SMF6DIE = 4;
    public static final int SMFCBIE = 1;
    public static final int SMF6FEXT = 128;
    public static final int SMF6REXT = 64;
    public static final int SMF6SEXT = 32;
    public static final int SMF6ESS1 = 16;
    public static final int SMF6FTFR = 8;
    public static final int SMF6END2 = 94;
    public static final int SMF6SIZ2 = 94;
    public static final int SMF6SIZ3 = 94;
    public static final int SMF6END = 116;
    public static final int SMF6SIZ = 116;
    public static final int SMF6LSIZ = 116;
    public static final int SMF6FEND = 100;
    public static final int SMF6FSIZ = 100;
    public static final int SMF6REND = 78;
    public static final int SMF6RSIZ = 78;
    public static final int SMF6DEND = 226;
    public static final int SMF6DSIZ = 226;
    public static final int SMF6EEND = 82;
    public static final int SMF6ESIZ = 82;
    public static final int SMF6SEND = 208;
    public static final int SMF6SSIZ = 208;
    public static final int SMF6TEND = 544;
    public static final int SMF6TSIZ = 544;

    public Smf6Record(byte[] data) {
        super(data);
        if (this.recordType() != 6) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf6Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 6) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf6Record from(SmfRecord record) {
        return new Smf6Record(record);
    }

    public static Smf6Record from(byte[] data) {
        return new Smf6Record(data);
    }

    public Smf6Subsystem subsystem() {
        switch (this.smf6sbs()) {
            case 0: {
                return Smf6Subsystem.externalWriter;
            }
            case 2: {
                return Smf6Subsystem.jes2;
            }
            case 5: {
                return Smf6Subsystem.jes3;
            }
            case 7: {
                return Smf6Subsystem.psf;
            }
            case 9: {
                return Smf6Subsystem.ipPrintway;
            }
        }
        return null;
    }

    private int iodataOffset() {
        return 64;
    }

    private int nonImpactPrintingOffset() {
        return this.iodataOffset() + this.smf6lnx(this.iodataOffset());
    }

    private int commonSectionOffset() {
        int offset = this.iodataOffset();
        offset += this.smf6lnx(offset);
        if (this.smf6fext()) {
            offset += this.smf6lnx(offset);
        }
        return offset;
    }

    private int apaSubsystemOffset() {
        int offset = this.iodataOffset();
        offset += this.smf6lnx(offset);
        if (this.smf6fext()) {
            offset += this.smf6lnx(offset);
        }
        if (this.smf6rext()) {
            offset += this.smf6lnx(offset);
        }
        return offset;
    }

    private int essSectionOffset() {
        int offset = this.iodataOffset();
        offset += this.smf6lnx(offset);
        if (this.smf6fext()) {
            offset += this.smf6lnx(offset);
        }
        if (this.smf6rext()) {
            offset += this.smf6lnx(offset);
        }
        if (this.smf6sext()) {
            offset += this.smf6lnx(offset);
        }
        return offset;
    }

    private int fileTransferOffset() {
        int offset = this.iodataOffset();
        offset += this.smf6lnx(offset);
        if (this.smf6fext()) {
            offset += this.smf6lnx(offset);
        }
        if (this.smf6rext()) {
            offset += this.smf6lnx(offset);
        }
        if (this.smf6sext()) {
            offset += this.smf6lnx(offset);
        }
        if (this.smf6ess1()) {
            offset += this.smf6lnx(offset);
        }
        return offset;
    }

    private int smf6lnx(int offset) {
        return Util.ConvertUnsignedBinary2(this.data, offset);
    }

    public IoDataSection ioDataSection() {
        if (this.m_ioDataSection == null) {
            this.m_ioDataSection = IoDataSection.create(this.data, this.iodataOffset(), this.smf6lnx(this.iodataOffset()), this.subsystem());
        }
        return this.m_ioDataSection;
    }

    public NonImpactPrintingSection nonImpactPrintingSubsystemSection() {
        if (this.m_nonImpactPrintingSubsystemSection == null && this.smf6fext()) {
            this.m_nonImpactPrintingSubsystemSection = NonImpactPrintingSection.create(this.data, this.nonImpactPrintingOffset(), this.smf6lnx(this.nonImpactPrintingOffset()));
        }
        return this.m_nonImpactPrintingSubsystemSection;
    }

    public CommonSection commonSection() {
        if (this.m_commonSection == null && this.smf6rext()) {
            this.m_commonSection = CommonSection.create(this.data, this.commonSectionOffset(), this.smf6lnx(this.commonSectionOffset()));
        }
        return this.m_commonSection;
    }

    public ApaPrintingSection apaSubsystemSection() {
        if (this.m_apaSubsystemSection == null && this.smf6sext()) {
            this.m_apaSubsystemSection = ApaPrintingSection.create(this.data, this.apaSubsystemOffset(), this.smf6lnx(this.apaSubsystemOffset()));
        }
        return this.m_apaSubsystemSection;
    }

    public EssSection enhancedSysoutSection() {
        if (this.m_enhancedSysoutSection == null && this.smf6ess1()) {
            this.m_enhancedSysoutSection = EssSection.create(this.data, this.essSectionOffset(), this.smf6lnx(this.essSectionOffset()));
        }
        return this.m_enhancedSysoutSection;
    }

    public FileTransferSection fileTransferSection() {
        if (this.m_fileTransferSection == null && this.smf6ftfr()) {
            this.m_fileTransferSection = FileTransferSection.create(this.data, this.fileTransferOffset(), this.smf6lnx(this.fileTransferOffset()));
        }
        return this.m_fileTransferSection;
    }

    public int smf6len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf6seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf6flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf6rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf6tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf6tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf6dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf6dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf6sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf6jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf6rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf6rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf6rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf6rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf6uif() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public String smf6owc() {
        return Util.ConvertEbcdic(this.data, 42, 1);
    }

    public LocalTime smf6wst() {
        return Util.Binary4x100STime(this.data, 43);
    }

    public long smf6wstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 43);
    }

    public LocalDate smf6wsd() {
        return Util.SMFDate(this.data, 47);
    }

    public int smf6wsdRawValue() {
        return Util.ConvertPacked4(this.data, 47);
    }

    public long smf6nlr() {
        return Util.ConvertUnsignedBinary4(this.data, 51);
    }

    public int smf6ioe() {
        return Util.ConvertUnsignedBinary1(this.data, 55);
    }

    public boolean smf6die() {
        return Util.ConvertFlag(this.data, this.smf6ioe(), 4);
    }

    public boolean smfcbie() {
        return Util.ConvertFlag(this.data, this.smf6ioe(), 1);
    }

    public int smf6nds() {
        return Util.ConvertUnsignedBinary1(this.data, 56);
    }

    public String smf6fmn() {
        return Util.ConvertEbcdic(this.data, 57, 4);
    }

    public int smf6pad1() {
        return Util.ConvertUnsignedBinary1(this.data, 61);
    }

    public boolean smf6fext() {
        return Util.ConvertFlag(this.data, this.smf6pad1(), 128);
    }

    public boolean smf6rext() {
        return Util.ConvertFlag(this.data, this.smf6pad1(), 64);
    }

    public boolean smf6sext() {
        return Util.ConvertFlag(this.data, this.smf6pad1(), 32);
    }

    public boolean smf6ess1() {
        return Util.ConvertFlag(this.data, this.smf6pad1(), 16);
    }

    public boolean smf6ftfr() {
        return Util.ConvertFlag(this.data, this.smf6pad1(), 8);
    }

    public int smf6sbs() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    static enum Field {
        smf6len(0, 2),
        smf6seg(2, 2),
        smf6flg(4, 1),
        smf6rty(5, 1),
        smf6tme(6, 4),
        smf6dte(10, 4),
        smf6sid(14, 4),
        smf6jbn(18, 8),
        smf6rst(26, 4),
        smf6rsd(30, 4),
        smf6uif(34, 8),
        smf6owc(42, 1),
        smf6wst(43, 4),
        smf6wsd(47, 4),
        smf6nlr(51, 4),
        smf6ioe(55, 1),
        smf6nds(56, 1),
        smf6fmn(57, 4),
        smf6pad1(61, 1),
        smf6sbs(62, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

