/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf61;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf60.EntryType;
import com.blackhillsoftware.smf.smf61.CatalogRecord;
import com.blackhillsoftware.smf.smf61.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf61Record
extends SmfRecord {
    public static final int SMF61SLF = 24;
    public static final int SMF61PRD = 40;
    public static final int SMF61DAT = 50;
    public static final int SMF61END = 208;

    public Smf61Record(byte[] data) {
        super(data);
        this.checkRecord();
    }

    public Smf61Record(SmfRecord record) {
        super(record);
        this.checkRecord();
    }

    public static Smf61Record from(SmfRecord record) {
        return new Smf61Record(record);
    }

    public static Smf61Record from(byte[] data) {
        return new Smf61Record(data);
    }

    private void checkRecord() {
        if (this.recordType() != 61) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        if (this.smf61pno() > 1) {
            throw new IllegalArgumentException("Multiple product sections found: " + Integer.toString(this.smf61pno()));
        }
        if (this.smf61dno() > 1) {
            throw new IllegalArgumentException("Multiple data sections found: " + Integer.toString(this.smf61dno()));
        }
    }

    public int smf61len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf61seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf61sys() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf61rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf61tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf61tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf61dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf61dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf61sid() {
        return Util.ConvertEbcdic(this.data, 14, 2);
    }

    public String smf61mod() {
        return Util.ConvertEbcdic(this.data, 16, 2);
    }

    public String smf61sub() {
        return Util.ConvertEbcdic(this.data, 22, 2);
    }

    public int smf61pof() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int smf61pln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf61pno() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smf61dof() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int smf61dln() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smf61dno() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String smf61ver() {
        return Util.ConvertEbcdic(this.data, 40, 2);
    }

    public String smf61pnm() {
        return Util.ConvertEbcdic(this.data, 42, 8);
    }

    public String smf61jnm() {
        return Util.ConvertEbcdic(this.data, 50, 8);
    }

    public LocalTime smf61rst() {
        return Util.Binary4x100STime(this.data, 58);
    }

    public long smf61rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 58);
    }

    public LocalDate smf61rdt() {
        return Util.SMFDate(this.data, 62);
    }

    public int smf61rdtRawValue() {
        return Util.ConvertPacked4(this.data, 62);
    }

    public String smf61uid() {
        return Util.ConvertEbcdic(this.data, 66, 8);
    }

    public String smf61cnm() {
        return Util.ConvertEbcdic(this.data, 75, 44);
    }

    public int smf61typ() {
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public EntryType smf61EntryType() {
        return EntryType.fromInt(this.smf61typ());
    }

    public String smf61enm() {
        return Util.ConvertEbcdic(this.data, 120, 44);
    }

    public CatalogRecord smf61crc() {
        int offset = this.smf61dof() + this.smf61dln();
        int length = CatalogRecord.smf61crl(this.data, offset);
        return CatalogRecord.create(this.data, offset, length);
    }

    public Timestamp timestamp() {
        int offset = this.smf61dof() + this.smf61dln();
        offset += CatalogRecord.smf61crl(this.data, offset);
        int length = Timestamp.Field.smf61ets.length();
        return Timestamp.create(this.data, offset, length);
    }

    static enum Field {
        smf61len(0, 2),
        smf61seg(2, 2),
        smf61sys(4, 1),
        smf61rty(5, 1),
        smf61tme(6, 4),
        smf61dte(10, 4),
        smf61sid(14, 2),
        smf61mod(16, 2),
        smf61sub(22, 2),
        smf61pof(24, 4),
        smf61pln(28, 2),
        smf61pno(30, 2),
        smf61dof(32, 4),
        smf61dln(36, 2),
        smf61dno(38, 2),
        smf61ver(40, 2),
        smf61pnm(42, 8),
        smf61jnm(50, 8),
        smf61rst(58, 4),
        smf61rdt(62, 4),
        smf61uid(66, 8),
        smf61cnm(75, 44),
        smf61typ(119, 1),
        smf61enm(120, 44),
        smf61crc(208, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

