/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf62;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf62.SmsInformation;
import com.blackhillsoftware.smf.smf62.StatisticsSection;
import com.blackhillsoftware.smf.smf62.VolumeEntry;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Smf62Record
extends SmfRecord {
    public static final int SMF62OOK = 128;
    public static final int SMF62SVL = 64;
    public static final int SMF62CRA = 32;
    public static final int SMF62ICF = 16;
    public static final int SMF62SMS = 8;
    public static final int SMF62DSENC = 4;
    public static final int SMF62DSEB = 2;
    public static final int SMF62ARCKEY = 1;
    private List<VolumeEntry> m_VolumeEntry = null;
    private SmsInformation m_SmsInformation = null;
    private StatisticsSection m_StatisticsSection = null;

    public Smf62Record(byte[] data) {
        super(data);
        if (this.recordType() != 62) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf62Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 62) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf62Record from(SmfRecord record) {
        return new Smf62Record(record);
    }

    public static Smf62Record from(byte[] data) {
        return new Smf62Record(data);
    }

    public int smf62len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf62seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf62flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf62rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf62tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf62tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf62dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf62dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf62sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf62jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf62rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf62rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf62rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf62rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf62uif() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public long smf62ind() {
        return Util.ConvertUnsignedBinary4(this.data, 42);
    }

    public boolean smf62ook() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 128, Field.smf62ind.length, 0);
    }

    public boolean smf62svl() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 64, Field.smf62ind.length, 0);
    }

    public boolean smf62cra() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 32, Field.smf62ind.length, 0);
    }

    public boolean smf62icf() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 16, Field.smf62ind.length, 0);
    }

    public boolean smf62sms() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 8, Field.smf62ind.length, 0);
    }

    public boolean smf62dsenc() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 4, Field.smf62ind.length, 0);
    }

    public boolean smf62dseb() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 2, Field.smf62ind.length, 0);
    }

    public boolean smf62arckey() {
        return Util.ConvertFlag(this.data, this.smf62ind(), 1, Field.smf62ind.length, 0);
    }

    public String smf62cnm() {
        return Util.ConvertEbcdic(this.data, 46, 44);
    }

    public String smf62cvs() {
        return Util.ConvertEbcdic(this.data, 90, 6);
    }

    public String smf62dnm() {
        return Util.ConvertEbcdic(this.data, 96, 44);
    }

    public int smf62vct() {
        return Util.ConvertUnsignedBinary2(this.data, 140);
    }

    public List<VolumeEntry> volumeEntries() {
        if (this.m_VolumeEntry == null) {
            if (this.smf62vct() == 0) {
                this.m_VolumeEntry = Collections.emptyList();
            } else {
                this.m_VolumeEntry = new ArrayList<VolumeEntry>(this.smf62vct());
                for (int i = 0; i < this.smf62vct(); ++i) {
                    this.m_VolumeEntry.add(VolumeEntry.create(this.data, Field.smf62vct.offset + Field.smf62vct.length + i * 10, 10));
                }
            }
        }
        return this.m_VolumeEntry;
    }

    public int smf62det() {
        return Util.ConvertUnsignedBinary2(this.data, 178);
    }

    public String smf62dkl() {
        return Util.ConvertEbcdic(this.data, 180, 64);
    }

    public String smf62jobid() {
        return Util.ConvertEbcdic(this.data, 244, 8);
    }

    public String smf62sysplexName() {
        return Util.ConvertEbcdic(this.data, 252, 8);
    }

    public SmsInformation smsInformation() {
        if (this.m_SmsInformation == null) {
            this.m_SmsInformation = SmsInformation.create(this.data, Field.smf62vct.offset + Field.smf62vct.length + this.smf62vct() * 10, SmsInformation.SMSINFORMATIONLENGTH);
        }
        return this.m_SmsInformation;
    }

    public StatisticsSection statisticsSection() {
        if (this.m_StatisticsSection == null) {
            int offset = Field.smf62vct.offset + Field.smf62vct.length + this.smf62vct() * 10 + SmsInformation.SMSINFORMATIONLENGTH;
            this.m_StatisticsSection = StatisticsSection.create(this.data, offset, Math.min(StatisticsSection.STATISTICSSECTIONLENGTH, this.data.length - offset));
        }
        return this.m_StatisticsSection;
    }

    static enum Field {
        smf62len(0, 2),
        smf62seg(2, 2),
        smf62flg(4, 1),
        smf62rty(5, 1),
        smf62tme(6, 4),
        smf62dte(10, 4),
        smf62sid(14, 4),
        smf62jbn(18, 8),
        smf62rst(26, 4),
        smf62rsd(30, 4),
        smf62uif(34, 8),
        smf62ind(42, 4),
        smf62cnm(46, 44),
        smf62cvs(90, 6),
        smf62dnm(96, 44),
        smf62vct(140, 2),
        smf62det(178, 2),
        smf62dkl(180, 64),
        smf62jobid(244, 8),
        smf62sysplexName(252, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

