/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class CpuControlSection
extends SmfData {
    public static final int SMF70DIF = 128;
    public static final int SMF70NPC = 64;
    public static final int SMF70TSC = 32;
    public static final int SMF70PHY = 16;
    public static final int SMF70DGE = 8;
    public static final int SMF70VMG = 4;
    public static final int SMF70STS = 128;
    public static final int SMF70ADC = 64;
    public static final int SMF70WUC = 32;
    public static final int SMF70RCU = 16;
    public static final int SMF70HWV = 8;
    public static final int SMF70PTC = 4;
    public static final int SMF70PLC = 2;
    public static final int SMF70GAV = 1;
    public static final int SMF70HHS = 128;
    public static final int SMF70HHA = 64;
    public static final int SMF70HHC = 32;
    public static final int SMF70HIF = 16;
    public static final int SMF70HAM = 8;
    public static final int SMF70HOP = 4;

    private CpuControlSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf70mod() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf70ver() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public int smf70bnp() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public int smf70inb() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf70dif() {
        return Util.ConvertFlag(this.data, this.smf70inb(), 128);
    }

    public boolean smf70npc() {
        return Util.ConvertFlag(this.data, this.smf70inb(), 64);
    }

    public boolean smf70tsc() {
        return Util.ConvertFlag(this.data, this.smf70inb(), 32);
    }

    public boolean smf70phy() {
        return Util.ConvertFlag(this.data, this.smf70inb(), 16);
    }

    public boolean smf70dge() {
        return Util.ConvertFlag(this.data, this.smf70inb(), 8);
    }

    public boolean smf70vmg() {
        return Util.ConvertFlag(this.data, this.smf70inb(), 4);
    }

    public int smf70stf() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public boolean smf70sts() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 128);
    }

    public boolean smf70adc() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 64);
    }

    public boolean smf70wuc() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 32);
    }

    public boolean smf70rcu() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 16);
    }

    public boolean smf70hwv() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 8);
    }

    public boolean smf70ptc() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 4);
    }

    public boolean smf70plc() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 2);
    }

    public boolean smf70gav() {
        return Util.ConvertFlag(this.data, this.smf70stf(), 1);
    }

    public Duration smf70gts() {
        return Util.ConvertBinary2MS(this.data, 6);
    }

    public double smf70gtsSeconds() {
        return Util.ToSeconds(this.smf70gts());
    }

    public int smf70gtsRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public String smf70mdl() {
        return Util.ConvertEbcdic(this.data, 8, 16);
    }

    public int smf70dsa() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf70ifa() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public long smf70cpa() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf70wla() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf70lac() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration smf70hof() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double smf70hofSeconds() {
        return Util.ToSeconds(this.smf70hof());
    }

    public long smf70hofRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public String smf70hwm() {
        return Util.ConvertEbcdic(this.data, 48, 16);
    }

    public int smf70sup() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public ZonedDateTime smf70gjt() {
        return Util.Binary8xStckTime(this.data, 66);
    }

    public BigInteger smf70gjtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 66);
    }

    public String smf70pom() {
        return Util.ConvertEbcdic(this.data, 74, 4);
    }

    public String smf70csc() {
        return Util.ConvertEbcdic(this.data, 78, 16);
    }

    public int smf70hhf() {
        return Util.ConvertUnsignedBinary1(this.data, 94);
    }

    public boolean smf70hhs() {
        return Util.ConvertFlag(this.data, this.smf70hhf(), 128);
    }

    public boolean smf70hha() {
        return Util.ConvertFlag(this.data, this.smf70hhf(), 64);
    }

    public boolean smf70hhc() {
        return Util.ConvertFlag(this.data, this.smf70hhf(), 32);
    }

    public boolean smf70hif() {
        return Util.ConvertFlag(this.data, this.smf70hhf(), 16);
    }

    public boolean smf70ham() {
        return Util.ConvertFlag(this.data, this.smf70hhf(), 8);
    }

    public boolean smf70hop() {
        return Util.ConvertFlag(this.data, this.smf70hhf(), 4);
    }

    public int smf70cr() {
        return Util.ConvertUnsignedBinary1(this.data, 95);
    }

    public long smf70pmi() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smf70pmu() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long smf70pmw() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long smf70pmp() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public int smf70pmt() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public int smf70pml() {
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public String smf70mpc() {
        return Util.ConvertEbcdic(this.data, 116, 16);
    }

    public String smf70mtc() {
        return Util.ConvertEbcdic(this.data, 132, 16);
    }

    public long smf70mcr() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public long smf70mpr() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long smf70mtr() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long smf70zep() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long smf70zer() {
        return Util.ConvertUnsignedBinary8(this.data, 164);
    }

    public BigInteger smf70zerAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 164);
    }

    public long smf70zee() {
        return Util.ConvertUnsignedBinary8(this.data, 172);
    }

    public BigInteger smf70zeeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 172);
    }

    public long smf70zec() {
        return Util.ConvertUnsignedBinary8(this.data, 180);
    }

    public BigInteger smf70zecAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 180);
    }

    public long smf70nrm() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long smf70gau() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long smf70zei() {
        return Util.ConvertSignedBinary8(this.data, 196);
    }

    public long smf70ncr() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long smf70npr() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public long smf70ntr() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public int smf70cai() {
        return Util.ConvertUnsignedBinary1(this.data, 216);
    }

    public int smf70ccr() {
        return Util.ConvertUnsignedBinary1(this.data, 217);
    }

    public int smf70mcp() {
        return Util.ConvertUnsignedBinary2(this.data, 218);
    }

    public int smf70icp() {
        return Util.ConvertUnsignedBinary2(this.data, 220);
    }

    public int smf70ccp() {
        return Util.ConvertUnsignedBinary2(this.data, 222);
    }

    public long smf70cpaActual() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public long smf70cpaScalingFactor() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public long smf70mcf() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public long smf70mcfs() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public long smf70mcfi() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long smf70cf() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long smf70cfs() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public long smf70cfi() {
        return Util.ConvertUnsignedBinary4(this.data, 252);
    }

    public long smf70atd() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long smf70atds() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long smf70atdi() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long smf70lacm() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public long smf70laca() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long smf70lacb() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public long smf70adj() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public long smf70laccr() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public int smf70maxpu() {
        return Util.ConvertUnsignedBinary2(this.data, 288);
    }

    public int smf70osPrtct() {
        return Util.ConvertUnsignedBinary1(this.data, 290);
    }

    public ZonedDateTime smf70IplTime() {
        return Util.Binary8xStckTime(this.data, 324);
    }

    public BigInteger smf70IplTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 324);
    }

    public long smf70TrgMCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 332);
    }

    public String smf70cpcType() {
        return Util.ConvertEbcdic(this.data, 340, 4);
    }

    public String smf70mdlVar() {
        return Util.ConvertEbcdic(this.data, 344, 16);
    }

    public long smf70mvcr() {
        return Util.ConvertUnsignedBinary4(this.data, 360);
    }

    public long smf70nvcr() {
        return Util.ConvertUnsignedBinary4(this.data, 364);
    }

    public long smf70zsuOnZiip() {
        return Util.ConvertUnsignedBinary8(this.data, 368);
    }

    public BigInteger smf70zsuOnZiipAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 368);
    }

    public long smf70zsuOnCp() {
        return Util.ConvertUnsignedBinary8(this.data, 376);
    }

    public BigInteger smf70zsuOnCpAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 376);
    }

    public long smf70jsuOnZiip() {
        return Util.ConvertUnsignedBinary8(this.data, 384);
    }

    public BigInteger smf70jsuOnZiipAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 384);
    }

    public long smf70jsuOnCp() {
        return Util.ConvertUnsignedBinary8(this.data, 392);
    }

    public BigInteger smf70jsuOnCpAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 392);
    }

    public int smf70cpeLo() {
        return Util.ConvertUnsignedBinary2(this.data, 400);
    }

    public int smf70cpeHi() {
        return Util.ConvertUnsignedBinary2(this.data, 402);
    }

    public static CpuControlSection create(byte[] Data2, int offset, int length) {
        return new CpuControlSection(Data2, offset, length);
    }

    static enum Field {
        smf70mod(0, 2),
        smf70ver(2, 1),
        smf70bnp(3, 1),
        smf70inb(4, 1),
        smf70stf(5, 1),
        smf70gts(6, 2),
        smf70mdl(8, 16),
        smf70dsa(24, 2),
        smf70ifa(26, 2),
        smf70cpa(28, 4),
        smf70wla(32, 4),
        smf70lac(36, 4),
        smf70hof(40, 8),
        smf70hwm(48, 16),
        smf70sup(64, 2),
        smf70gjt(66, 8),
        smf70pom(74, 4),
        smf70csc(78, 16),
        smf70hhf(94, 1),
        smf70cr(95, 1),
        smf70pmi(96, 4),
        smf70pmu(100, 4),
        smf70pmw(104, 4),
        smf70pmp(108, 4),
        smf70pmt(112, 2),
        smf70pml(114, 2),
        smf70mpc(116, 16),
        smf70mtc(132, 16),
        smf70mcr(148, 4),
        smf70mpr(152, 4),
        smf70mtr(156, 4),
        smf70zep(160, 4),
        smf70zer(164, 8),
        smf70zee(172, 8),
        smf70zec(180, 8),
        smf70nrm(188, 4),
        smf70gau(192, 4),
        smf70zei(196, 8),
        smf70ncr(204, 4),
        smf70npr(208, 4),
        smf70ntr(212, 4),
        smf70cai(216, 1),
        smf70ccr(217, 1),
        smf70mcp(218, 2),
        smf70icp(220, 2),
        smf70ccp(222, 2),
        smf70cpaActual(224, 4),
        smf70cpaScalingFactor(228, 4),
        smf70mcf(232, 4),
        smf70mcfs(236, 4),
        smf70mcfi(240, 4),
        smf70cf(244, 4),
        smf70cfs(248, 4),
        smf70cfi(252, 4),
        smf70atd(256, 4),
        smf70atds(260, 4),
        smf70atdi(264, 4),
        smf70lacm(268, 4),
        smf70laca(272, 4),
        smf70lacb(276, 4),
        smf70adj(280, 4),
        smf70laccr(284, 4),
        smf70maxpu(288, 2),
        smf70osPrtct(290, 1),
        smf70IplTime(324, 8),
        smf70TrgMCnt(332, 4),
        smf70cpcType(340, 4),
        smf70mdlVar(344, 16),
        smf70mvcr(360, 4),
        smf70nvcr(364, 4),
        smf70zsuOnZiip(368, 8),
        smf70zsuOnCp(376, 8),
        smf70jsuOnZiip(384, 8),
        smf70jsuOnCp(392, 8),
        smf70cpeLo(400, 2),
        smf70cpeHi(402, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

