/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype2;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class CryptographicCcaCoprocessorDataSection
extends SmfData {
    public static final int R7023ALL = 128;
    public static final int R7023RSA = 64;

    private CryptographicCcaCoprocessorDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r7023ax() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int r7023ct() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int r7023msk() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean r7023all() {
        return Util.ConvertFlag(this.data, this.r7023msk(), 128);
    }

    public boolean r7023rsa() {
        return Util.ConvertFlag(this.data, this.r7023msk(), 64);
    }

    public int r7023mt() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public double r7023sf() {
        return Util.ConvertLongFPHex(this.data, 8);
    }

    public Duration r7023t0() {
        return Util.LongFPHex_SecondsScaled(this.data, 16, this.r7023sf());
    }

    public double r7023t0Seconds() {
        return this.r7023t0RawValue() * this.r7023sf();
    }

    public double r7023t0RawValue() {
        return Util.ConvertLongFPHex(this.data, 16);
    }

    public double r7023c0() {
        return Util.ConvertLongFPHex(this.data, 24);
    }

    public double r7023c1() {
        return Util.ConvertLongFPHex(this.data, 40);
    }

    public int r7023scope() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int r7023did() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public static CryptographicCcaCoprocessorDataSection create(byte[] Data2, int offset, int length) {
        return new CryptographicCcaCoprocessorDataSection(Data2, offset, length);
    }

    static enum Field {
        r7023ax(0, 1),
        r7023ct(1, 1),
        r7023msk(2, 1),
        r7023mt(3, 1),
        r7023sf(8, 8),
        r7023t0(16, 8),
        r7023c0(24, 8),
        r7023c1(40, 8),
        r7023scope(48, 1),
        r7023did(49, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

