/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf71;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf71.Header;
import com.blackhillsoftware.smf.smf71.ProductSection;
import com.blackhillsoftware.smf.smf71.subtype1.PagingDataSection;
import com.blackhillsoftware.smf.smf71.subtype1.SwapPlacementSection;
import java.util.List;

public final class Smf71Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<PagingDataSection> buildPagingDataSection = new CreateSection<PagingDataSection>(){

        @Override
        public PagingDataSection createSection(byte[] data, int offset, int length) {
            return PagingDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<SwapPlacementSection> buildSwapPlacementSection = new CreateSection<SwapPlacementSection>(){

        @Override
        public SwapPlacementSection createSection(byte[] data, int offset, int length) {
            return SwapPlacementSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<PagingDataSection> m_pagingDataSections = null;
    private List<SwapPlacementSection> m_swapPlacementSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf71Record(byte[] data) {
        super(data);
        if (this.recordType() != 71) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf71Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 71) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf71Record from(SmfRecord record) {
        return new Smf71Record(record);
    }

    public static Smf71Record from(byte[] data) {
        return new Smf71Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf71prs.offset() + tempHeader.smf71trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public List<PagingDataSection> pagingDataSections() {
        this.m_pagingDataSections = Util.sectionsFromTriplet(this.m_pagingDataSections, this.data, Triplets.PagingDataSection.getTriplet(this.header()), buildPagingDataSection);
        return this.m_pagingDataSections;
    }

    public List<SwapPlacementSection> swapPlacementSections() {
        this.m_swapPlacementSections = Util.sectionsFromTriplet(this.m_swapPlacementSections, this.data, Triplets.SwapPlacementSection.getTriplet(this.header()), buildSwapPlacementSection);
        return this.m_swapPlacementSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf71prs(), header.smf71prl(), header.smf71prn());
            }
        }
        ,
        PagingDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf71pds(), header.smf71pdl(), header.smf71pdn());
            }
        }
        ,
        SwapPlacementSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf71sws(), header.smf71swl(), header.smf71swn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

