/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf72;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf72.Header;
import com.blackhillsoftware.smf.smf72.ProductSection;
import com.blackhillsoftware.smf.smf72.subtype3.ResourceDelayTypeNamesSection;
import com.blackhillsoftware.smf.smf72.subtype3.ResourceGroupDataSection;
import com.blackhillsoftware.smf.smf72.subtype3.ResponseTimeDistributionDataSection;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceClassServedDataSection;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import com.blackhillsoftware.smf.smf72.subtype3.WorkManagerResourceManagerStateSection;
import com.blackhillsoftware.smf.smf72.subtype3.WorkloadManagerControlSection;
import com.blackhillsoftware.smf.smf72.subtype4.ServiceClassPeriodDataSection;
import com.blackhillsoftware.smf.smf72.subtype4.SwapReasonDataSection;
import com.blackhillsoftware.smf.smf72.subtype5.CmlLockOwnerDataSection;
import com.blackhillsoftware.smf.smf72.subtype5.CmlLockRequestorDataSection;
import com.blackhillsoftware.smf.smf72.subtype5.CmsLockTypeData;
import com.blackhillsoftware.smf.smf72.subtype5.GrsEnqueueData;
import com.blackhillsoftware.smf.smf72.subtype5.GrsLatchTypeData;
import com.blackhillsoftware.smf.smf72.subtype5.GrsQScanStatisticsDataSection;
import com.blackhillsoftware.smf.smf72.subtype5.LocalLockDataSection;
import com.blackhillsoftware.smf.smf72.subtype5.SerializationControlSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Smf72Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<WorkloadManagerControlSection> buildWorkloadManagerControlSection = new CreateSection<WorkloadManagerControlSection>(){

        @Override
        public WorkloadManagerControlSection createSection(byte[] data, int offset, int length) {
            return WorkloadManagerControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ServiceClassServedDataSection> buildServiceClassServedDataSection = new CreateSection<ServiceClassServedDataSection>(){

        @Override
        public ServiceClassServedDataSection createSection(byte[] data, int offset, int length) {
            return ServiceClassServedDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ResourceGroupDataSection> buildResourceGroupDataSection = new CreateSection<ResourceGroupDataSection>(){

        @Override
        public ResourceGroupDataSection createSection(byte[] data, int offset, int length) {
            return ResourceGroupDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ResponseTimeDistributionDataSection> buildResponseTimeDistributionDataSection = new CreateSection<ResponseTimeDistributionDataSection>(){

        @Override
        public ResponseTimeDistributionDataSection createSection(byte[] data, int offset, int length) {
            return ResponseTimeDistributionDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<WorkManagerResourceManagerStateSection> buildWorkManagerResourceManagerStateSection = new CreateSection<WorkManagerResourceManagerStateSection>(){

        @Override
        public WorkManagerResourceManagerStateSection createSection(byte[] data, int offset, int length) {
            return WorkManagerResourceManagerStateSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ResourceDelayTypeNamesSection> buildResourceDelayTypeNamesSection = new CreateSection<ResourceDelayTypeNamesSection>(){

        @Override
        public ResourceDelayTypeNamesSection createSection(byte[] data, int offset, int length) {
            return ResourceDelayTypeNamesSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ServiceClassPeriodDataSection> buildServiceClassPeriodDataSection = new CreateSection<ServiceClassPeriodDataSection>(){

        @Override
        public ServiceClassPeriodDataSection createSection(byte[] data, int offset, int length) {
            return ServiceClassPeriodDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<SwapReasonDataSection> buildSwapReasonDataSection = new CreateSection<SwapReasonDataSection>(){

        @Override
        public SwapReasonDataSection createSection(byte[] data, int offset, int length) {
            return SwapReasonDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<SerializationControlSection> buildSerializationControlSection = new CreateSection<SerializationControlSection>(){

        @Override
        public SerializationControlSection createSection(byte[] data, int offset, int length) {
            return SerializationControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CmsLockTypeData> buildCmsLockTypeData = new CreateSection<CmsLockTypeData>(){

        @Override
        public CmsLockTypeData createSection(byte[] data, int offset, int length) {
            return CmsLockTypeData.create(data, offset, length);
        }
    };
    private static final CreateSection<LocalLockDataSection> buildLocalLockDataSection = new CreateSection<LocalLockDataSection>(){

        @Override
        public LocalLockDataSection createSection(byte[] data, int offset, int length) {
            return LocalLockDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CmlLockOwnerDataSection> buildCmlLockOwnerDataSection = new CreateSection<CmlLockOwnerDataSection>(){

        @Override
        public CmlLockOwnerDataSection createSection(byte[] data, int offset, int length) {
            return CmlLockOwnerDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CmlLockRequestorDataSection> buildCmlLockRequestorDataSection = new CreateSection<CmlLockRequestorDataSection>(){

        @Override
        public CmlLockRequestorDataSection createSection(byte[] data, int offset, int length) {
            return CmlLockRequestorDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<GrsLatchTypeData> buildGrsLatchTypeData = new CreateSection<GrsLatchTypeData>(){

        @Override
        public GrsLatchTypeData createSection(byte[] data, int offset, int length) {
            return GrsLatchTypeData.create(data, offset, length);
        }
    };
    private static final CreateSection<GrsEnqueueData> buildGrsEnqueueData = new CreateSection<GrsEnqueueData>(){

        @Override
        public GrsEnqueueData createSection(byte[] data, int offset, int length) {
            return GrsEnqueueData.create(data, offset, length);
        }
    };
    private static final CreateSection<GrsQScanStatisticsDataSection> buildGrsQScanStatisticsDataSection = new CreateSection<GrsQScanStatisticsDataSection>(){

        @Override
        public GrsQScanStatisticsDataSection createSection(byte[] data, int offset, int length) {
            return GrsQScanStatisticsDataSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<ServiceClassServedDataSection> m_serviceClassServedDataSections = null;
    private List<ResourceGroupDataSection> m_resourceGroupDataSections = null;
    private List<ServiceReportClassPeriodDataSection> m_serviceReportClassPeriodDataSections = null;
    private List<ResponseTimeDistributionDataSection> m_responseTimeDistributionDataSections = null;
    private List<WorkManagerResourceManagerStateSection> m_workManagerResourceManagerStateSections = null;
    private List<ResourceDelayTypeNamesSection> m_resourceDelayTypeNamesSections = null;
    private List<ServiceClassPeriodDataSection> m_serviceClassPeriodDataSections = null;
    private List<SwapReasonDataSection> m_swapReasonDataSections = null;
    private List<SerializationControlSection> m_serializationControlSections = null;
    private List<CmsLockTypeData> m_cmsLockDataSections = null;
    private List<CmsLockTypeData> m_cmsEnqueueDequeueLockDataSections = null;
    private List<CmsLockTypeData> m_cmsLatchLockDataSections = null;
    private List<CmsLockTypeData> m_cmsSmfLockDataSections = null;
    private List<LocalLockDataSection> m_localLockDataSections = null;
    private List<CmlLockOwnerDataSection> m_cmlLockOwnerDataSections = null;
    private List<CmlLockRequestorDataSection> m_cmlLockRequestorDataSections = null;
    private List<GrsLatchTypeData> m_grsLatchSetCreatorDataSections = null;
    private List<GrsLatchTypeData> m_grsLatchRequestorDataSections = null;
    private List<GrsEnqueueData> m_grsEnqueueStepDataSections = null;
    private List<GrsEnqueueData> m_grsEnqueueSystemDataSections = null;
    private List<GrsEnqueueData> m_grsEnqueueSystemsDataSections = null;
    private List<GrsQScanStatisticsDataSection> m_grsQScanStatisticsDataSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;
    private WorkloadManagerControlSection m_controlSection = null;

    public Smf72Record(byte[] data) {
        super(data);
        if (this.recordType() != 72) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf72Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 72) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf72Record from(SmfRecord record) {
        return new Smf72Record(record);
    }

    public static Smf72Record from(byte[] data) {
        return new Smf72Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf72prs.offset() + tempHeader.smf72trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public WorkloadManagerControlSection workloadManagerControlSection() {
        if (this.m_controlSection == null) {
            Triplet t = Triplets.WorkloadManagerControlSection.getTriplet(this.header());
            this.m_controlSection = buildWorkloadManagerControlSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_controlSection;
    }

    public List<ServiceClassServedDataSection> serviceClassServedDataSections() {
        this.m_serviceClassServedDataSections = Util.sectionsFromTriplet(this.m_serviceClassServedDataSections, this.data, Triplets.ServiceClassServedDataSection.getTriplet(this.header()), buildServiceClassServedDataSection);
        return this.m_serviceClassServedDataSections;
    }

    public List<ResourceGroupDataSection> resourceGroupDataSections() {
        this.m_resourceGroupDataSections = Util.sectionsFromTriplet(this.m_resourceGroupDataSections, this.data, Triplets.ResourceGroupDataSection.getTriplet(this.header()), buildResourceGroupDataSection);
        return this.m_resourceGroupDataSections;
    }

    public List<ServiceReportClassPeriodDataSection> serviceReportClassPeriodDataSections() {
        if (this.m_serviceReportClassPeriodDataSections != null) {
            return this.m_serviceReportClassPeriodDataSections;
        }
        Triplet t = Triplets.ServiceReportClassPeriodDataSection.getTriplet(this.header());
        if (t.getCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ServiceReportClassPeriodDataSection> result = new ArrayList<ServiceReportClassPeriodDataSection>(t.getCount());
        WorkloadManagerControlSection controlsection = this.workloadManagerControlSection();
        List<ResponseTimeDistributionDataSection> responsemap = this.responseTimeDistributionDataSections();
        for (int i = 0; i < t.getCount(); ++i) {
            result.add(ServiceReportClassPeriodDataSection.create(this.data, t.getOffset() + i * t.getLength(), t.getLength(), controlsection, responsemap));
        }
        this.m_serviceReportClassPeriodDataSections = Collections.unmodifiableList(result);
        return this.m_serviceReportClassPeriodDataSections;
    }

    public List<ResponseTimeDistributionDataSection> responseTimeDistributionDataSections() {
        this.m_responseTimeDistributionDataSections = Util.sectionsFromTriplet(this.m_responseTimeDistributionDataSections, this.data, Triplets.ResponseTimeDistributionDataSection.getTriplet(this.header()), buildResponseTimeDistributionDataSection);
        return this.m_responseTimeDistributionDataSections;
    }

    public List<WorkManagerResourceManagerStateSection> workManagerResourceManagerStateSections() {
        this.m_workManagerResourceManagerStateSections = Util.sectionsFromTriplet(this.m_workManagerResourceManagerStateSections, this.data, Triplets.WorkManagerResourceManagerStateSection.getTriplet(this.header()), buildWorkManagerResourceManagerStateSection);
        return this.m_workManagerResourceManagerStateSections;
    }

    public List<ResourceDelayTypeNamesSection> resourceDelayTypeNamesSections() {
        this.m_resourceDelayTypeNamesSections = Util.sectionsFromTriplet(this.m_resourceDelayTypeNamesSections, this.data, Triplets.ResourceDelayTypeNamesSection.getTriplet(this.header()), buildResourceDelayTypeNamesSection);
        return this.m_resourceDelayTypeNamesSections;
    }

    public List<ServiceClassPeriodDataSection> serviceClassPeriodDataSections() {
        this.m_serviceClassPeriodDataSections = Util.sectionsFromTriplet(this.m_serviceClassPeriodDataSections, this.data, Triplets.ServiceClassPeriodDataSection.getTriplet(this.header()), buildServiceClassPeriodDataSection);
        return this.m_serviceClassPeriodDataSections;
    }

    public List<SwapReasonDataSection> swapReasonDataSections() {
        this.m_swapReasonDataSections = Util.sectionsFromTriplet(this.m_swapReasonDataSections, this.data, Triplets.SwapReasonDataSection.getTriplet(this.header()), buildSwapReasonDataSection);
        return this.m_swapReasonDataSections;
    }

    public List<SerializationControlSection> serializationControlSections() {
        this.m_serializationControlSections = Util.sectionsFromTriplet(this.m_serializationControlSections, this.data, Triplets.SerializationControlSection.getTriplet(this.header()), buildSerializationControlSection);
        return this.m_serializationControlSections;
    }

    public List<CmsLockTypeData> cmsLockDataSections() {
        this.m_cmsLockDataSections = Util.sectionsFromTriplet(this.m_cmsLockDataSections, this.data, Triplets.CmsLockDataSection.getTriplet(this.header()), buildCmsLockTypeData);
        return this.m_cmsLockDataSections;
    }

    public List<CmsLockTypeData> cmsEnqueueDequeueLockDataSections() {
        this.m_cmsEnqueueDequeueLockDataSections = Util.sectionsFromTriplet(this.m_cmsEnqueueDequeueLockDataSections, this.data, Triplets.CmsEnqueueDequeueLockDataSection.getTriplet(this.header()), buildCmsLockTypeData);
        return this.m_cmsEnqueueDequeueLockDataSections;
    }

    public List<CmsLockTypeData> cmsLatchLockDataSections() {
        this.m_cmsLatchLockDataSections = Util.sectionsFromTriplet(this.m_cmsLatchLockDataSections, this.data, Triplets.CmsLatchLockDataSection.getTriplet(this.header()), buildCmsLockTypeData);
        return this.m_cmsLatchLockDataSections;
    }

    public List<CmsLockTypeData> cmsSmfLockDataSections() {
        this.m_cmsSmfLockDataSections = Util.sectionsFromTriplet(this.m_cmsSmfLockDataSections, this.data, Triplets.CmsSmfLockDataSection.getTriplet(this.header()), buildCmsLockTypeData);
        return this.m_cmsSmfLockDataSections;
    }

    public List<LocalLockDataSection> localLockDataSections() {
        this.m_localLockDataSections = Util.sectionsFromTriplet(this.m_localLockDataSections, this.data, Triplets.LocalLockDataSection.getTriplet(this.header()), buildLocalLockDataSection);
        return this.m_localLockDataSections;
    }

    public List<CmlLockOwnerDataSection> cmlLockOwnerDataSections() {
        this.m_cmlLockOwnerDataSections = Util.sectionsFromTriplet(this.m_cmlLockOwnerDataSections, this.data, Triplets.CmlLockOwnerDataSection.getTriplet(this.header()), buildCmlLockOwnerDataSection);
        return this.m_cmlLockOwnerDataSections;
    }

    public List<CmlLockRequestorDataSection> cmlLockRequestorDataSections() {
        this.m_cmlLockRequestorDataSections = Util.sectionsFromTriplet(this.m_cmlLockRequestorDataSections, this.data, Triplets.CmlLockRequestorDataSection.getTriplet(this.header()), buildCmlLockRequestorDataSection);
        return this.m_cmlLockRequestorDataSections;
    }

    public List<GrsLatchTypeData> grsLatchSetCreatorDataSections() {
        this.m_grsLatchSetCreatorDataSections = Util.sectionsFromTriplet(this.m_grsLatchSetCreatorDataSections, this.data, Triplets.GrsLatchSetCreatorDataSection.getTriplet(this.header()), buildGrsLatchTypeData);
        return this.m_grsLatchSetCreatorDataSections;
    }

    public List<GrsLatchTypeData> grsLatchRequestorDataSections() {
        this.m_grsLatchRequestorDataSections = Util.sectionsFromTriplet(this.m_grsLatchRequestorDataSections, this.data, Triplets.GrsLatchRequestorDataSection.getTriplet(this.header()), buildGrsLatchTypeData);
        return this.m_grsLatchRequestorDataSections;
    }

    public List<GrsEnqueueData> grsEnqueueStepDataSections() {
        this.m_grsEnqueueStepDataSections = Util.sectionsFromTriplet(this.m_grsEnqueueStepDataSections, this.data, Triplets.GrsEnqueueStepDataSection.getTriplet(this.header()), buildGrsEnqueueData);
        return this.m_grsEnqueueStepDataSections;
    }

    public List<GrsEnqueueData> grsEnqueueSystemDataSections() {
        this.m_grsEnqueueSystemDataSections = Util.sectionsFromTriplet(this.m_grsEnqueueSystemDataSections, this.data, Triplets.GrsEnqueueSystemDataSection.getTriplet(this.header()), buildGrsEnqueueData);
        return this.m_grsEnqueueSystemDataSections;
    }

    public List<GrsEnqueueData> grsEnqueueSystemsDataSections() {
        this.m_grsEnqueueSystemsDataSections = Util.sectionsFromTriplet(this.m_grsEnqueueSystemsDataSections, this.data, Triplets.GrsEnqueueSystemsDataSection.getTriplet(this.header()), buildGrsEnqueueData);
        return this.m_grsEnqueueSystemsDataSections;
    }

    public List<GrsQScanStatisticsDataSection> grsQScanStatisticsDataSections() {
        this.m_grsQScanStatisticsDataSections = Util.sectionsFromTriplet(this.m_grsQScanStatisticsDataSections, this.data, Triplets.GrsQScanStatisticsDataSection.getTriplet(this.header()), buildGrsQScanStatisticsDataSection);
        return this.m_grsQScanStatisticsDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72prs(), header.smf72prl(), header.smf72prn());
            }
        }
        ,
        WorkloadManagerControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72wms(), header.smf72wml(), header.smf72wmn());
            }
        }
        ,
        ServiceClassServedDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72sss(), header.smf72ssl(), header.smf72ssn());
            }
        }
        ,
        ResourceGroupDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72rgs(), header.smf72rgl(), header.smf72rgn());
            }
        }
        ,
        ServiceReportClassPeriodDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72scs(), header.smf72scl(), header.smf72scn());
            }
        }
        ,
        ResponseTimeDistributionDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72rts(), header.smf72rtl(), header.smf72rtn());
            }
        }
        ,
        WorkManagerResourceManagerStateSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72wrs(), header.smf72wrl(), header.smf72wrn());
            }
        }
        ,
        ResourceDelayTypeNamesSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72dns(), header.smf72dnl(), header.smf72dnn());
            }
        }
        ,
        ServiceClassPeriodDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72cps(), header.smf72cpl(), header.smf72cpn());
            }
        }
        ,
        SwapReasonDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72sps(), header.smf72spl(), header.smf72spn());
            }
        }
        ,
        SerializationControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72ses(), header.smf72sel(), header.smf72sen());
            }
        }
        ,
        CmsLockDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72cms(), header.smf72cml(), header.smf72cmn());
            }
        }
        ,
        CmsEnqueueDequeueLockDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72eds(), header.smf72edl(), header.smf72edn());
            }
        }
        ,
        CmsLatchLockDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72las(), header.smf72lal(), header.smf72lan());
            }
        }
        ,
        CmsSmfLockDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72sms(), header.smf72sml(), header.smf72smn());
            }
        }
        ,
        LocalLockDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72los(), header.smf72lol(), header.smf72lon());
            }
        }
        ,
        CmlLockOwnerDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72cos(), header.smf72col(), header.smf72con());
            }
        }
        ,
        CmlLockRequestorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72crs(), header.smf72crl(), header.smf72crn());
            }
        }
        ,
        GrsLatchSetCreatorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72lcs(), header.smf72lcl(), header.smf72lcn());
            }
        }
        ,
        GrsLatchRequestorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72lrs(), header.smf72lrl(), header.smf72lrn());
            }
        }
        ,
        GrsEnqueueStepDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72tds(), header.smf72tdl(), header.smf72tdn());
            }
        }
        ,
        GrsEnqueueSystemDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72yds(), header.smf72ydl(), header.smf72ydn());
            }
        }
        ,
        GrsEnqueueSystemsDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72sds(), header.smf72sdl(), header.smf72sdn());
            }
        }
        ,
        GrsQScanStatisticsDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf72qss(), header.smf72qsl(), header.smf72qsn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

