/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf72.subtype3;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;

public final class WorkloadManagerControlSection
extends SmfData {
    public static final int R723MRCL = 128;
    public static final int R723MCAA = 64;
    public static final int R723MPOL = 32;
    public static final int R723MOVE = 16;
    public static final int R723MCPP = 8;
    public static final int R723MSTP = 4;
    public static final int R723MDAT = 2;
    public static final int R723MIPG = 1;
    public static final int R723MICO = 128;
    public static final int R723MHPO = 64;
    public static final int R723MHPZ = 32;
    public static final int R723HISF = 16;
    public static final int R723MNHP = 8;
    public static final int R723MTRC = 4;
    public static final int R723MDIS = 2;
    public static final int R723MBAI = 1;
    public static final int R723MAPO = 128;
    public static final int R723MSEC = 2;

    private WorkloadManagerControlSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r723mscf() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean r723mrcl() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 128);
    }

    public boolean r723mcaa() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 64);
    }

    public boolean r723mpol() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 32);
    }

    public boolean r723move() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 16);
    }

    public boolean r723mcpp() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 8);
    }

    public boolean r723mstp() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 4);
    }

    public boolean r723mdat() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 2);
    }

    public boolean r723mipg() {
        return Util.ConvertFlag(this.data, this.r723mscf(), 1);
    }

    public int r723mflg() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean r723mico() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 128);
    }

    public boolean r723mhpo() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 64);
    }

    public boolean r723mhpz() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 32);
    }

    public boolean r723hisf() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 16);
    }

    public boolean r723mnhp() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 8);
    }

    public boolean r723mtrc() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 4);
    }

    public boolean r723mdis() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 2);
    }

    public boolean r723mbai() {
        return Util.ConvertFlag(this.data, this.r723mflg(), 1);
    }

    public int r723mfl2() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean r723mapo() {
        return Util.ConvertFlag(this.data, this.r723mfl2(), 128);
    }

    public int r723mrs2() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public String r723mnsp() {
        return Util.ConvertEbcdic(this.data, 4, 8);
    }

    public String r723mdsp() {
        return Util.ConvertEbcdic(this.data, 12, 32);
    }

    public LocalDateTime r723mtpa() {
        return Util.Binary8xStckLocalTime(this.data, 44);
    }

    public BigInteger r723mtpaRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 44);
    }

    public long r723mcpu() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long r723mioc() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long r723mmso() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long r723msrb() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public Duration r723mtvl() {
        return Util.Binary4MS(this.data, 68);
    }

    public double r723mtvlSeconds() {
        return Util.ToSeconds(this.r723mtvl());
    }

    public long r723mtvlRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long r723mtvNum() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public String r723mopt() {
        return Util.ConvertEbcdic(this.data, 76, 2);
    }

    public String r723mrs3() {
        return Util.ConvertEbcdic(this.data, 78, 2);
    }

    public String r723mwnm() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public String r723mwde() {
        return Util.ConvertEbcdic(this.data, 88, 32);
    }

    public String r723mcnm() {
        return Util.ConvertEbcdic(this.data, 120, 8);
    }

    public String r723mcde() {
        return Util.ConvertEbcdic(this.data, 128, 32);
    }

    public int r723mcpg() {
        return Util.ConvertUnsignedBinary2(this.data, 160);
    }

    public int r723msub() {
        return Util.ConvertUnsignedBinary1(this.data, 162);
    }

    public String r723merf() {
        return Util.ConvertEbcdic(this.data, 166, 6);
    }

    public long r723madj() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public String r723midn() {
        return Util.ConvertEbcdic(this.data, 176, 8);
    }

    public String r723midd() {
        return Util.ConvertEbcdic(this.data, 184, 32);
    }

    public LocalDateTime r723mtdi() {
        return Util.Binary8xStckLocalTime(this.data, 216);
    }

    public BigInteger r723mtdiRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public String r723midu() {
        return Util.ConvertEbcdic(this.data, 224, 8);
    }

    public String r723clsc() {
        return Util.ConvertEbcdic(this.data, 232, 8);
    }

    public long r723nffi() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long r723nffs() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long r723nadj() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public long r723ceca() {
        return Util.ConvertUnsignedBinary4(this.data, 252);
    }

    public long r723mcf() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long r723mcfs() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long r723mcfi() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long r723cpaActual() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public long r723cpaScalingFactor() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public static WorkloadManagerControlSection create(byte[] Data2, int offset, int length) {
        return new WorkloadManagerControlSection(Data2, offset, length);
    }

    static enum Field {
        r723mscf(0, 1),
        r723mflg(1, 1),
        r723mfl2(2, 1),
        r723mrs2(3, 1),
        r723mnsp(4, 8),
        r723mdsp(12, 32),
        r723mtpa(44, 8),
        r723mcpu(52, 4),
        r723mioc(56, 4),
        r723mmso(60, 4),
        r723msrb(64, 4),
        r723mtvl(68, 4),
        r723mtvNum(72, 4),
        r723mopt(76, 2),
        r723mrs3(78, 2),
        r723mwnm(80, 8),
        r723mwde(88, 32),
        r723mcnm(120, 8),
        r723mcde(128, 32),
        r723mcpg(160, 2),
        r723msub(162, 1),
        r723merf(166, 6),
        r723madj(172, 4),
        r723midn(176, 8),
        r723midd(184, 32),
        r723mtdi(216, 8),
        r723midu(224, 8),
        r723clsc(232, 8),
        r723nffi(240, 4),
        r723nffs(244, 4),
        r723nadj(248, 4),
        r723ceca(252, 4),
        r723mcf(256, 4),
        r723mcfs(260, 4),
        r723mcfi(264, 4),
        r723cpaActual(268, 4),
        r723cpaScalingFactor(272, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

