/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf73;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf73.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF73CNV = 128;
    public static final int SMF73ISS = 64;
    public static final int SMF73M3R = 32;
    public static final int SMF73ISM = 16;
    public static final int SMF73RCL = 8;
    public static final int SMF73RCH = 4;
    public static final int SMF73AltVM = 2;
    public static final int SMF73IIP = 64;
    public static final int SMF73EED = 32;
    public static final int SMF73BOO = 7;
    public static final int SMF73QES = 128;
    public static final int SMF73CNE = 64;
    public static final int SMF73DRC = 32;
    public static final int SMF73EME = 16;
    public static final int SMF73PRI = 8;
    public static final int SMF73PRP = 4;
    public static final int SMF73PED = 2;
    public static final int SMF73PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf73ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf73rao(), this.smf73ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf73mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf73prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf73ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf73istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf73dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf73datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf73int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf73intSeconds() {
        return Util.ToSeconds(this.smf73int());
    }

    public int smf73intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf73mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf73sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf73rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf73fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf73cnv() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 128, Field.smf73fla.length, 0);
    }

    public boolean smf73iss() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 64, Field.smf73fla.length, 0);
    }

    public boolean smf73m3r() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 32, Field.smf73fla.length, 0);
    }

    public boolean smf73ism() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 16, Field.smf73fla.length, 0);
    }

    public boolean smf73rcl() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 8, Field.smf73fla.length, 0);
    }

    public boolean smf73rch() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 4, Field.smf73fla.length, 0);
    }

    public boolean smf73altVm() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 2, Field.smf73fla.length, 0);
    }

    public boolean smf73iip() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 64, Field.smf73fla.length, 1);
    }

    public boolean smf73eed() {
        return Util.ConvertFlag(this.data, this.smf73fla(), 32, Field.smf73fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf73iip() || this.smf73eed()) {
            return BoostClass.from(this.smf73fla() & 7);
        }
        return null;
    }

    public String smf73rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf73cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf73cycSeconds() {
        return Util.ToSeconds(this.smf73cyc());
    }

    public int smf73cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf73mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf73iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf73prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf73qes() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 128);
    }

    public boolean smf73cne() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 64);
    }

    public boolean smf73drc() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 32);
    }

    public boolean smf73eme() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 16);
    }

    public boolean smf73pri() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 8);
    }

    public boolean smf73prp() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 4);
    }

    public boolean smf73ped() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 2);
    }

    public boolean smf73pe2() {
        return Util.ConvertFlag(this.data, this.smf73prf(), 1);
    }

    public int smf73ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf73srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf73iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf73ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf73lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf73lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf73rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf73ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf73ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf73oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf73oilSeconds() {
        return Util.ToSeconds(this.smf73oil());
    }

    public int smf73oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf73syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf73synSeconds() {
        return Util.ToSeconds(this.smf73syn());
    }

    public int smf73synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf73gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf73gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf73xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf73snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf73mfv(0, 2),
        smf73prd(2, 8),
        smf73ist(10, 4),
        smf73dat(14, 4),
        smf73int(18, 4),
        smf73mfl(22, 2),
        smf73sam(24, 4),
        smf73rv2(28, 2),
        smf73fla(30, 2),
        smf73rls(32, 4),
        smf73cyc(36, 4),
        smf73mvs(40, 8),
        smf73iml(48, 1),
        smf73prf(49, 1),
        smf73ptn(50, 1),
        smf73srl(51, 1),
        smf73iet(52, 8),
        smf73lgo(60, 8),
        smf73rao(68, 4),
        smf73ral(72, 2),
        smf73ran(74, 2),
        smf73oil(76, 2),
        smf73syn(78, 2),
        smf73gie(80, 8),
        smf73xnm(88, 8),
        smf73snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

