/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf73;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf73.Header;
import com.blackhillsoftware.smf.smf73.ProductSection;
import com.blackhillsoftware.smf.smf73.subtype1.ChannelPathControlSection;
import com.blackhillsoftware.smf.smf73.subtype1.ChannelPathDataSection;
import com.blackhillsoftware.smf.smf73.subtype1.ExtendedChannelPathDataSection;
import java.util.List;

public final class Smf73Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ChannelPathControlSection> buildChannelPathControlSection = new CreateSection<ChannelPathControlSection>(){

        @Override
        public ChannelPathControlSection createSection(byte[] data, int offset, int length) {
            return ChannelPathControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ChannelPathDataSection> buildChannelPathDataSection = new CreateSection<ChannelPathDataSection>(){

        @Override
        public ChannelPathDataSection createSection(byte[] data, int offset, int length) {
            return ChannelPathDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ExtendedChannelPathDataSection> buildExtendedChannelPathDataSection = new CreateSection<ExtendedChannelPathDataSection>(){

        @Override
        public ExtendedChannelPathDataSection createSection(byte[] data, int offset, int length) {
            return ExtendedChannelPathDataSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<ChannelPathControlSection> m_channelPathControlSections = null;
    private List<ChannelPathDataSection> m_channelPathDataSections = null;
    private List<ExtendedChannelPathDataSection> m_extendedChannelPathDataSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf73Record(byte[] data) {
        super(data);
        if (this.recordType() != 73) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf73Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 73) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf73Record from(SmfRecord record) {
        return new Smf73Record(record);
    }

    public static Smf73Record from(byte[] data) {
        return new Smf73Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf73prs.offset() + tempHeader.smf73trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public List<ChannelPathControlSection> channelPathControlSections() {
        this.m_channelPathControlSections = Util.sectionsFromTriplet(this.m_channelPathControlSections, this.data, Triplets.ChannelPathControlSection.getTriplet(this.header()), buildChannelPathControlSection);
        return this.m_channelPathControlSections;
    }

    public List<ChannelPathDataSection> channelPathDataSections() {
        this.m_channelPathDataSections = Util.sectionsFromTriplet(this.m_channelPathDataSections, this.data, Triplets.ChannelPathDataSection.getTriplet(this.header()), buildChannelPathDataSection);
        return this.m_channelPathDataSections;
    }

    public List<ExtendedChannelPathDataSection> extendedChannelPathDataSections() {
        this.m_extendedChannelPathDataSections = Util.sectionsFromTriplet(this.m_extendedChannelPathDataSections, this.data, Triplets.ExtendedChannelPathDataSection.getTriplet(this.header()), buildExtendedChannelPathDataSection);
        return this.m_extendedChannelPathDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf73prs(), header.smf73prl(), header.smf73prn());
            }
        }
        ,
        ChannelPathControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf73his(), header.smf73hil(), header.smf73hin());
            }
        }
        ,
        ChannelPathDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf73hps(), header.smf73hpl(), header.smf73hpn());
            }
        }
        ,
        ExtendedChannelPathDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf73hes(), header.smf73hel(), header.smf73hen());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

