/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype10;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class ScmConfigurationMeasurementSection
extends SmfData {
    public static final int R7410VFM = 128;

    private ScmConfigurationMeasurementSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r7410crpi() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int r7410crid() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int r7410cpid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public long r7410cdus() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long r7410crqc() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long r7410crq() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long r7410cdwc() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long r7410cdw() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long r7410cdrc() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long r7410cdr() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration r7410crtc() {
        return Util.Binary4x128US(this.data, 32);
    }

    public double r7410crtcSeconds() {
        return Util.ToSeconds(this.r7410crtc());
    }

    public long r7410crtcRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration r7410crt() {
        return Util.Binary4x128US(this.data, 36);
    }

    public double r7410crtSeconds() {
        return Util.ToSeconds(this.r7410crt());
    }

    public long r7410crtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration r7410ciqc() {
        return Util.Binary4x128US(this.data, 40);
    }

    public double r7410ciqcSeconds() {
        return Util.ToSeconds(this.r7410ciqc());
    }

    public long r7410ciqcRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long r7410cwuc() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long r7410cwu() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public int r7410flg() {
        return Util.ConvertUnsignedBinary1(this.data, 52);
    }

    public boolean r7410vfm() {
        return Util.ConvertFlag(this.data, this.r7410flg(), 128);
    }

    public static ScmConfigurationMeasurementSection create(byte[] Data2, int offset, int length) {
        return new ScmConfigurationMeasurementSection(Data2, offset, length);
    }

    static enum Field {
        r7410crpi(0, 4),
        r7410crid(0, 2),
        r7410cpid(2, 2),
        r7410cdus(4, 4),
        r7410crqc(8, 4),
        r7410crq(12, 4),
        r7410cdwc(16, 4),
        r7410cdw(20, 4),
        r7410cdrc(24, 4),
        r7410cdr(28, 4),
        r7410crtc(32, 4),
        r7410crt(36, 4),
        r7410ciqc(40, 4),
        r7410cwuc(44, 4),
        r7410cwu(48, 4),
        r7410flg(52, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

