/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype10;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class ScmDeviceInformationSection
extends SmfData {
    public static final int R7410ECPR = 128;

    private ScmDeviceInformationSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r7410dsct() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long r7410dnum() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public Duration r7410dfpt() {
        return Util.Binary8x128US(this.data, 8);
    }

    public double r7410dfptSeconds() {
        return Util.ToSeconds(this.r7410dfpt());
    }

    public long r7410dfptRawValue() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public Duration r7410diqt() {
        return Util.Binary8x128US(this.data, 16);
    }

    public double r7410diqtSeconds() {
        return Util.ToSeconds(this.r7410diqt());
    }

    public long r7410diqtRawValue() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public Duration r7410dcrt() {
        return Util.Binary8x128US(this.data, 24);
    }

    public double r7410dcrtSeconds() {
        return Util.ToSeconds(this.r7410dcrt());
    }

    public long r7410dcrtRawValue() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public int r7410dflg() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public boolean r7410ecpr() {
        return Util.ConvertFlag(this.data, this.r7410dflg(), 128);
    }

    public long r7410docc() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long r7410docd() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long r7410disc() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger r7410discAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long r7410dosc() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger r7410doscAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long r7410disd() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger r7410disdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long r7410dosd() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger r7410dosdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public static ScmDeviceInformationSection create(byte[] Data2, int offset, int length) {
        return new ScmDeviceInformationSection(Data2, offset, length);
    }

    static enum Field {
        r7410dsct(0, 4),
        r7410dnum(4, 4),
        r7410dfpt(8, 8),
        r7410diqt(16, 8),
        r7410dcrt(24, 8),
        r7410dflg(32, 1),
        r7410docc(40, 4),
        r7410docd(44, 4),
        r7410disc(48, 8),
        r7410dosc(56, 8),
        r7410disd(64, 8),
        r7410dosd(72, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

