/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype2;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf74.subtype2.PathUsageStatisticsBlock;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class XcfPathDataSection
extends SmfData {
    List<PathUsageStatisticsBlock> m_pathUsageStatisticsBlocks = null;
    public static final int R742PACT = 128;
    public static final int R742PIAC = 64;
    public static final int R742PRES = 32;
    public static final int R742PPAR = 16;
    public static final int R742PIN = 128;
    public static final int R742POUT = 64;
    public static final int R742PST = 128;
    public static final int R742PRS = 64;
    public static final int R742PWK = 32;
    public static final int R742PSP = 16;
    public static final int R742PLK = 8;
    public static final int R742PNP = 4;
    public static final int R742PSF = 2;
    public static final int R742PRB = 1;
    public static final int R742PQG = 128;
    public static final int R742PQD = 64;

    private XcfPathDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public List<PathUsageStatisticsBlock> pathUsageStatisticsBlocks() {
        int PATHUSAGESTATISTICSBLOCKOFFSET = 112;
        int PATHUSAGESTATISTICSBLOCKSIZE = 32;
        int PATHUSAGESTATISTICSBLOCKCOUNT = 4;
        if (this.m_pathUsageStatisticsBlocks != null) {
            return this.m_pathUsageStatisticsBlocks;
        }
        ArrayList<PathUsageStatisticsBlock> result = new ArrayList<PathUsageStatisticsBlock>(4);
        for (int i = 0; i < 4; ++i) {
            result.add(PathUsageStatisticsBlock.create(this.data, 112 + i * 32, 32));
        }
        this.m_pathUsageStatisticsBlocks = Collections.unmodifiableList(result);
        return this.m_pathUsageStatisticsBlocks;
    }

    public String r742pnme() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String r742pdev() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public int r742pstf() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public boolean r742pact() {
        return Util.ConvertFlag(this.data, this.r742pstf(), 128);
    }

    public boolean r742piac() {
        return Util.ConvertFlag(this.data, this.r742pstf(), 64);
    }

    public boolean r742pres() {
        return Util.ConvertFlag(this.data, this.r742pstf(), 32);
    }

    public boolean r742ppar() {
        return Util.ConvertFlag(this.data, this.r742pstf(), 16);
    }

    public int r742pdir() {
        return Util.ConvertUnsignedBinary1(this.data, 13);
    }

    public boolean r742pin() {
        return Util.ConvertFlag(this.data, this.r742pdir(), 128);
    }

    public boolean r742pout() {
        return Util.ConvertFlag(this.data, this.r742pdir(), 64);
    }

    public int r742ptyp() {
        return Util.ConvertUnsignedBinary1(this.data, 14);
    }

    public String r742pona() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String r742podv() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    public int r742psta() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean r742pst() {
        return Util.ConvertFlag(this.data, this.r742psta(), 128);
    }

    public boolean r742prs() {
        return Util.ConvertFlag(this.data, this.r742psta(), 64);
    }

    public boolean r742pwk() {
        return Util.ConvertFlag(this.data, this.r742psta(), 32);
    }

    public boolean r742psp() {
        return Util.ConvertFlag(this.data, this.r742psta(), 16);
    }

    public boolean r742plk() {
        return Util.ConvertFlag(this.data, this.r742psta(), 8);
    }

    public boolean r742pnp() {
        return Util.ConvertFlag(this.data, this.r742psta(), 4);
    }

    public boolean r742psf() {
        return Util.ConvertFlag(this.data, this.r742psta(), 2);
    }

    public boolean r742prb() {
        return Util.ConvertFlag(this.data, this.r742psta(), 1);
    }

    public int r742pstm() {
        return Util.ConvertUnsignedBinary1(this.data, 29);
    }

    public boolean r742pqg() {
        return Util.ConvertFlag(this.data, this.r742pstm(), 128);
    }

    public boolean r742pqd() {
        return Util.ConvertFlag(this.data, this.r742pstm(), 64);
    }

    public long r742pret() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long r742prst() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long r742pmxm() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long r742psig() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long r742pqln() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long r742pibr() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long r742psus() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long r742papp() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public String r742ptcn() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public String r742pstr() {
        return Util.ConvertEbcdic(this.data, 72, 16);
    }

    public Duration r742piot() {
        return Util.Binary4US(this.data, 88);
    }

    public double r742piotSeconds() {
        return Util.ToSeconds(this.r742piot());
    }

    public long r742piotRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long r742prct() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long r742ppnd() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long r742puse() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long r742plin() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration r742pnibTimeSum() {
        return Util.Binary8USSeconds(this.data, 240);
    }

    public double r742pnibTimeSumSeconds() {
        return Util.ToSeconds(this.r742pnibTimeSum());
    }

    public BigInteger r742pnibTimeSumRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 240);
    }

    public long r742pnibTimeSsq() {
        return Util.ConvertUnsignedBinary8(this.data, 248);
    }

    public BigInteger r742pnibTimeSsqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 248);
    }

    public long r742pnibTimeNum() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public static XcfPathDataSection create(byte[] Data2, int offset, int length) {
        return new XcfPathDataSection(Data2, offset, length);
    }

    static enum Field {
        r742pnme(0, 8),
        r742pdev(8, 4),
        r742pstf(12, 1),
        r742pdir(13, 1),
        r742ptyp(14, 1),
        r742pona(16, 8),
        r742podv(24, 4),
        r742psta(28, 1),
        r742pstm(29, 1),
        r742pret(32, 4),
        r742prst(36, 4),
        r742pmxm(40, 4),
        r742psig(44, 4),
        r742pqln(48, 4),
        r742pibr(52, 4),
        r742psus(56, 4),
        r742papp(60, 4),
        r742ptcn(64, 8),
        r742pstr(72, 16),
        r742piot(88, 4),
        r742prct(92, 4),
        r742ppnd(96, 4),
        r742puse(100, 4),
        r742plin(104, 4),
        r742pnibTimeSum(240, 8),
        r742pnibTimeSsq(248, 8),
        r742pnibTimeNum(256, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

