/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype2;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class XcfSystemDataSection
extends SmfData {
    public static final int R742SACT = 128;
    public static final int R742SIAC = 64;
    public static final int R742SRES = 32;
    public static final int R742SPAR = 16;
    public static final int R742SIN = 128;
    public static final int R742SOUT = 64;
    public static final int R742SLCL = 32;

    private XcfSystemDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String r742snme() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public int r742sstf() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public boolean r742sact() {
        return Util.ConvertFlag(this.data, this.r742sstf(), 128);
    }

    public boolean r742siac() {
        return Util.ConvertFlag(this.data, this.r742sstf(), 64);
    }

    public boolean r742sres() {
        return Util.ConvertFlag(this.data, this.r742sstf(), 32);
    }

    public boolean r742spar() {
        return Util.ConvertFlag(this.data, this.r742sstf(), 16);
    }

    public int r742sdir() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean r742sin() {
        return Util.ConvertFlag(this.data, this.r742sdir(), 128);
    }

    public boolean r742sout() {
        return Util.ConvertFlag(this.data, this.r742sdir(), 64);
    }

    public boolean r742slcl() {
        return Util.ConvertFlag(this.data, this.r742sdir(), 32);
    }

    public long r742spth() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long r742sbsy() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long r742snop() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long r742smxb() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long r742sbig() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long r742sfit() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long r742ssml() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long r742sovr() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long r742stcl() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public String r742stcn() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public static XcfSystemDataSection create(byte[] Data2, int offset, int length) {
        return new XcfSystemDataSection(Data2, offset, length);
    }

    static enum Field {
        r742snme(0, 8),
        r742sstf(8, 1),
        r742sdir(9, 1),
        r742spth(12, 4),
        r742sbsy(16, 4),
        r742snop(20, 4),
        r742smxb(24, 4),
        r742sbig(28, 4),
        r742sfit(32, 4),
        r742ssml(36, 4),
        r742sovr(40, 4),
        r742stcl(44, 4),
        r742stcn(48, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

