/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype4;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class CfChannelPathDataSection
extends SmfData {
    public static final int R744HHCA = 128;
    public static final int R744HMOV = 64;
    public static final int R744HLAV = 32;
    public static final int R744HDEV = 16;
    public static final int R744HSAV = 15;
    public static final int R744HPCV = 128;
    public static final int R744HDEG = 128;
    public static final int R744HSND = 64;

    private CfChannelPathDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r744hcpi() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public String r744htap() {
        return Util.ConvertEbcdic(this.data, 1, 5);
    }

    public int r744hfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public boolean r744hhca() {
        return Util.ConvertFlag(this.data, this.r744hfl1(), 128);
    }

    public boolean r744hmov() {
        return Util.ConvertFlag(this.data, this.r744hfl1(), 64);
    }

    public boolean r744hlav() {
        return Util.ConvertFlag(this.data, this.r744hfl1(), 32);
    }

    public boolean r744hdev() {
        return Util.ConvertFlag(this.data, this.r744hfl1(), 16);
    }

    public int r744hfl2() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public boolean r744hpcv() {
        return Util.ConvertFlag(this.data, this.r744hfl2(), 128);
    }

    public int r744hopm() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public int r744hchf() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public boolean r744hdeg() {
        return Util.ConvertFlag(this.data, this.r744hchf(), 128);
    }

    public boolean r744hsnd() {
        return Util.ConvertFlag(this.data, this.r744hchf(), 64);
    }

    public long r744hlat() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int r744hpcp() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public int r744haid() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public int r744hapn() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    public String r744hsas() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    public int r744hsap() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public static CfChannelPathDataSection create(byte[] Data2, int offset, int length) {
        return new CfChannelPathDataSection(Data2, offset, length);
    }

    static enum Field {
        r744hcpi(0, 1),
        r744htap(1, 5),
        r744hfl1(6, 1),
        r744hfl2(7, 1),
        r744hopm(10, 1),
        r744hchf(11, 1),
        r744hlat(12, 4),
        r744hpcp(16, 2),
        r744haid(18, 2),
        r744hapn(20, 1),
        r744hsas(24, 4),
        r744hsap(24, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

