/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype4;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class CfStructureDataSection
extends SmfData {
    public static final int R744QACT = 128;
    public static final int R744QRBN = 64;
    public static final int R744QRBO = 32;
    public static final int R744QTRA = 16;
    public static final int R744QHOL = 8;
    public static final int R744QDPT = 4;
    public static final int R744QRBP = 2;
    public static final int R744QRBD = 1;
    public static final int R744QAAD = 128;

    private CfStructureDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String r744qstr() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public long r744qsiz() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public ZonedDateTime r744qver() {
        return Util.Binary8xStckTime(this.data, 20);
    }

    public BigInteger r744qverRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 20);
    }

    public int r744qflg() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean r744qact() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 128);
    }

    public boolean r744qrbn() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 64);
    }

    public boolean r744qrbo() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 32);
    }

    public boolean r744qtra() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 16);
    }

    public boolean r744qhol() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 8);
    }

    public boolean r744qdpt() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 4);
    }

    public boolean r744qrbp() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 2);
    }

    public boolean r744qrbd() {
        return Util.ConvertFlag(this.data, this.r744qflg(), 1);
    }

    public int r744qfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 29);
    }

    public boolean r744qaad() {
        return Util.ConvertFlag(this.data, this.r744qfl1(), 128);
    }

    public static CfStructureDataSection create(byte[] Data2, int offset, int length) {
        return new CfStructureDataSection(Data2, offset, length);
    }

    static enum Field {
        r744qstr(0, 16),
        r744qsiz(16, 4),
        r744qver(20, 8),
        r744qflg(28, 1),
        r744qfl1(29, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

