/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf75.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class PageDatasetDataSection
extends SmfData {
    public static final int SMF75LPA = 128;
    public static final int SMF75COM = 64;
    public static final int SMF75DPL = 32;
    public static final int SMF75LOC = 16;
    public static final int SMF75SWP = 8;
    public static final int SMF75DSB = 4;
    public static final int SMF75ONL = 2;
    public static final int SMF75OFL = 1;
    public static final int SMF75VIO = 128;
    public static final int SMF75MXP = 64;
    public static final int SMF75ACU = 32;
    public static final int SMF75DNM = 16;
    public static final int SMF75SCM = 8;

    private PageDatasetDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf75dsn() {
        return Util.ConvertEbcdic(this.data, 0, 44);
    }

    public int smf75pst() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public boolean smf75lpa() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 128);
    }

    public boolean smf75com() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 64);
    }

    public boolean smf75dpl() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 32);
    }

    public boolean smf75loc() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 16);
    }

    public boolean smf75swp() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 8);
    }

    public boolean smf75dsb() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 4);
    }

    public boolean smf75onl() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 2);
    }

    public boolean smf75ofl() {
        return Util.ConvertFlag(this.data, this.smf75pst(), 1);
    }

    public int smf75fl2() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public boolean smf75vio() {
        return Util.ConvertFlag(this.data, this.smf75fl2(), 128);
    }

    public boolean smf75mxp() {
        return Util.ConvertFlag(this.data, this.smf75fl2(), 64);
    }

    public boolean smf75acu() {
        return Util.ConvertFlag(this.data, this.smf75fl2(), 32);
    }

    public boolean smf75dnm() {
        return Util.ConvertFlag(this.data, this.smf75fl2(), 16);
    }

    public boolean smf75scm() {
        return Util.ConvertFlag(this.data, this.smf75fl2(), 8);
    }

    public int smf75rv5() {
        return Util.ConvertUnsignedBinary1(this.data, 46);
    }

    public long smf75typ() {
        return Util.ConvertUnsignedBinary4(this.data, 47);
    }

    public int smf75cha() {
        return Util.ConvertUnsignedBinary2(this.data, 51);
    }

    public String smf75vol() {
        return Util.ConvertEbcdic(this.data, 53, 6);
    }

    public int smf75scs() {
        return Util.ConvertUnsignedBinary1(this.data, 59);
    }

    public String smf75rv3() {
        return Util.ConvertEbcdic(this.data, 60, 4);
    }

    public long smf75sla() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf75mxu() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf75mnu() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf75avu() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long smf75bds() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf75use() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf75req() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf75sio() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf75pgx() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public String smf75dev() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String smf75cu() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public double smf75lvu() {
        return Util.ConvertLongFPHex(this.data, 116);
    }

    public static PageDatasetDataSection create(byte[] Data2, int offset, int length) {
        return new PageDatasetDataSection(Data2, offset, length);
    }

    static enum Field {
        smf75dsn(0, 44),
        smf75pst(44, 1),
        smf75fl2(45, 1),
        smf75rv5(46, 1),
        smf75typ(47, 4),
        smf75cha(51, 2),
        smf75vol(53, 6),
        smf75scs(59, 1),
        smf75rv3(60, 4),
        smf75sla(64, 4),
        smf75mxu(68, 4),
        smf75mnu(72, 4),
        smf75avu(76, 4),
        smf75bds(80, 4),
        smf75use(84, 4),
        smf75req(88, 4),
        smf75sio(92, 4),
        smf75pgx(96, 4),
        smf75dev(100, 8),
        smf75cu(108, 8),
        smf75lvu(116, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

