/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf77;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf77.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF77CNV = 128;
    public static final int SMF77ISS = 64;
    public static final int SMF77M3R = 32;
    public static final int SMF77ISM = 16;
    public static final int SMF77RCL = 8;
    public static final int SMF77RCH = 4;
    public static final int SMF77AltVM = 2;
    public static final int SMF77IIP = 64;
    public static final int SMF77EED = 32;
    public static final int SMF77BOO = 7;
    public static final int SMF77QES = 128;
    public static final int SMF77CNE = 64;
    public static final int SMF77DRC = 32;
    public static final int SMF77EME = 16;
    public static final int SMF77PRI = 8;
    public static final int SMF77PRP = 4;
    public static final int SMF77PED = 2;
    public static final int SMF77PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf77ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf77rao(), this.smf77ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf77mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf77prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf77ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf77istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf77dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf77datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf77int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf77intSeconds() {
        return Util.ToSeconds(this.smf77int());
    }

    public int smf77intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf77mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf77sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf77rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf77fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf77cnv() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 128, Field.smf77fla.length, 0);
    }

    public boolean smf77iss() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 64, Field.smf77fla.length, 0);
    }

    public boolean smf77m3r() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 32, Field.smf77fla.length, 0);
    }

    public boolean smf77ism() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 16, Field.smf77fla.length, 0);
    }

    public boolean smf77rcl() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 8, Field.smf77fla.length, 0);
    }

    public boolean smf77rch() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 4, Field.smf77fla.length, 0);
    }

    public boolean smf77altVm() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 2, Field.smf77fla.length, 0);
    }

    public boolean smf77iip() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 64, Field.smf77fla.length, 1);
    }

    public boolean smf77eed() {
        return Util.ConvertFlag(this.data, this.smf77fla(), 32, Field.smf77fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf77iip() || this.smf77eed()) {
            return BoostClass.from(this.smf77fla() & 7);
        }
        return null;
    }

    public String smf77rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf77cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf77cycSeconds() {
        return Util.ToSeconds(this.smf77cyc());
    }

    public int smf77cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf77mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf77iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf77prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf77qes() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 128);
    }

    public boolean smf77cne() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 64);
    }

    public boolean smf77drc() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 32);
    }

    public boolean smf77eme() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 16);
    }

    public boolean smf77pri() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 8);
    }

    public boolean smf77prp() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 4);
    }

    public boolean smf77ped() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 2);
    }

    public boolean smf77pe2() {
        return Util.ConvertFlag(this.data, this.smf77prf(), 1);
    }

    public int smf77ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf77srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf77iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf77ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf77lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf77lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf77rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf77ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf77ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf77oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf77oilSeconds() {
        return Util.ToSeconds(this.smf77oil());
    }

    public int smf77oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf77syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf77synSeconds() {
        return Util.ToSeconds(this.smf77syn());
    }

    public int smf77synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf77gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf77gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf77xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf77snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf77mfv(0, 2),
        smf77prd(2, 8),
        smf77ist(10, 4),
        smf77dat(14, 4),
        smf77int(18, 4),
        smf77mfl(22, 2),
        smf77sam(24, 4),
        smf77rv2(28, 2),
        smf77fla(30, 2),
        smf77rls(32, 4),
        smf77cyc(36, 4),
        smf77mvs(40, 8),
        smf77iml(48, 1),
        smf77prf(49, 1),
        smf77ptn(50, 1),
        smf77srl(51, 1),
        smf77iet(52, 8),
        smf77lgo(60, 8),
        smf77rao(68, 4),
        smf77ral(72, 2),
        smf77ran(74, 2),
        smf77oil(76, 2),
        smf77syn(78, 2),
        smf77gie(80, 8),
        smf77xnm(88, 8),
        smf77snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

