/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf78;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf78.Header;
import com.blackhillsoftware.smf.smf78.ProductSection;
import com.blackhillsoftware.smf.smf78.subtype2.VirtualStorageCommonStorageDataSection;
import com.blackhillsoftware.smf.smf78.subtype2.VirtualStoragePrivateAreaDataSection;
import com.blackhillsoftware.smf.smf78.subtype2.VirtualStoragePrivateAreaSubpoolSection;
import com.blackhillsoftware.smf.smf78.subtype3.HyperPavDataSection;
import com.blackhillsoftware.smf.smf78.subtype3.IoControlSection;
import com.blackhillsoftware.smf.smf78.subtype3.IoQueuingConfigurationControlSection;
import com.blackhillsoftware.smf.smf78.subtype3.IoQueuingDataSection;
import java.util.List;

public final class Smf78Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<VirtualStorageCommonStorageDataSection> buildVirtualStorageCommonStorageDataSection = new CreateSection<VirtualStorageCommonStorageDataSection>(){

        @Override
        public VirtualStorageCommonStorageDataSection createSection(byte[] data, int offset, int length) {
            return VirtualStorageCommonStorageDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<VirtualStoragePrivateAreaDataSection> buildVirtualStoragePrivateAreaDataSection = new CreateSection<VirtualStoragePrivateAreaDataSection>(){

        @Override
        public VirtualStoragePrivateAreaDataSection createSection(byte[] data, int offset, int length) {
            return VirtualStoragePrivateAreaDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<VirtualStoragePrivateAreaSubpoolSection> buildVirtualStoragePrivateAreaSubpoolSection = new CreateSection<VirtualStoragePrivateAreaSubpoolSection>(){

        @Override
        public VirtualStoragePrivateAreaSubpoolSection createSection(byte[] data, int offset, int length) {
            return VirtualStoragePrivateAreaSubpoolSection.create(data, offset, length);
        }
    };
    private static final CreateSection<IoControlSection> buildIoControlSection = new CreateSection<IoControlSection>(){

        @Override
        public IoControlSection createSection(byte[] data, int offset, int length) {
            return IoControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<IoQueuingConfigurationControlSection> buildIoQueuingConfigurationControlSection = new CreateSection<IoQueuingConfigurationControlSection>(){

        @Override
        public IoQueuingConfigurationControlSection createSection(byte[] data, int offset, int length) {
            return IoQueuingConfigurationControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<IoQueuingDataSection> buildIoQueuingDataSection = new CreateSection<IoQueuingDataSection>(){

        @Override
        public IoQueuingDataSection createSection(byte[] data, int offset, int length) {
            return IoQueuingDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<HyperPavDataSection> buildHyperPavDataSection = new CreateSection<HyperPavDataSection>(){

        @Override
        public HyperPavDataSection createSection(byte[] data, int offset, int length) {
            return HyperPavDataSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<VirtualStorageCommonStorageDataSection> m_virtualStorageCommonStorageDataSections = null;
    private List<VirtualStoragePrivateAreaDataSection> m_virtualStoragePrivateAreaDataSections = null;
    private List<VirtualStoragePrivateAreaSubpoolSection> m_virtualStoragePrivateAreaSubpoolSections = null;
    private List<IoControlSection> m_ioControlSections = null;
    private List<IoQueuingConfigurationControlSection> m_ioQueuingConfigurationControlSections = null;
    private List<IoQueuingDataSection> m_ioQueuingDataSections = null;
    private List<HyperPavDataSection> m_hyperPavDataSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf78Record(byte[] data) {
        super(data);
        if (this.recordType() != 78) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf78Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 78) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf78Record from(SmfRecord record) {
        return new Smf78Record(record);
    }

    public static Smf78Record from(byte[] data) {
        return new Smf78Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf78prs.offset() + tempHeader.smf78trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public List<VirtualStorageCommonStorageDataSection> virtualStorageCommonStorageDataSections() {
        this.m_virtualStorageCommonStorageDataSections = Util.sectionsFromTriplet(this.m_virtualStorageCommonStorageDataSections, this.data, Triplets.VirtualStorageCommonStorageDataSection.getTriplet(this.header()), buildVirtualStorageCommonStorageDataSection);
        return this.m_virtualStorageCommonStorageDataSections;
    }

    public List<VirtualStoragePrivateAreaDataSection> virtualStoragePrivateAreaDataSections() {
        this.m_virtualStoragePrivateAreaDataSections = Util.sectionsFromTriplet(this.m_virtualStoragePrivateAreaDataSections, this.data, Triplets.VirtualStoragePrivateAreaDataSection.getTriplet(this.header()), buildVirtualStoragePrivateAreaDataSection);
        return this.m_virtualStoragePrivateAreaDataSections;
    }

    public List<VirtualStoragePrivateAreaSubpoolSection> virtualStoragePrivateAreaSubpoolSections() {
        this.m_virtualStoragePrivateAreaSubpoolSections = Util.sectionsFromTriplet(this.m_virtualStoragePrivateAreaSubpoolSections, this.data, Triplets.VirtualStoragePrivateAreaSubpoolSection.getTriplet(this.header()), buildVirtualStoragePrivateAreaSubpoolSection);
        return this.m_virtualStoragePrivateAreaSubpoolSections;
    }

    public List<IoControlSection> ioControlSections() {
        this.m_ioControlSections = Util.sectionsFromTriplet(this.m_ioControlSections, this.data, Triplets.IoControlSection.getTriplet(this.header()), buildIoControlSection);
        return this.m_ioControlSections;
    }

    public List<IoQueuingConfigurationControlSection> ioQueuingConfigurationControlSections() {
        this.m_ioQueuingConfigurationControlSections = Util.sectionsFromTriplet(this.m_ioQueuingConfigurationControlSections, this.data, Triplets.IoQueuingConfigurationControlSection.getTriplet(this.header()), buildIoQueuingConfigurationControlSection);
        return this.m_ioQueuingConfigurationControlSections;
    }

    public List<IoQueuingDataSection> ioQueuingDataSections() {
        this.m_ioQueuingDataSections = Util.sectionsFromTriplet(this.m_ioQueuingDataSections, this.data, Triplets.IoQueuingDataSection.getTriplet(this.header()), buildIoQueuingDataSection);
        return this.m_ioQueuingDataSections;
    }

    public List<HyperPavDataSection> hyperPavDataSections() {
        this.m_hyperPavDataSections = Util.sectionsFromTriplet(this.m_hyperPavDataSections, this.data, Triplets.HyperPavDataSection.getTriplet(this.header()), buildHyperPavDataSection);
        return this.m_hyperPavDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78prs(), header.smf78prl(), header.smf78prn());
            }
        }
        ,
        VirtualStorageCommonStorageDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78dcs(), header.smf78dcl(), header.smf78dcn());
            }
        }
        ,
        VirtualStoragePrivateAreaDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78ass(), header.smf78asl(), header.smf78asn());
            }
        }
        ,
        VirtualStoragePrivateAreaSubpoolSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78sps(), header.smf78spl(), header.smf78spn());
            }
        }
        ,
        IoControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78qds(), header.smf78qdl(), header.smf78qdn());
            }
        }
        ,
        IoQueuingConfigurationControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78dcs(), header.smf78dcl(), header.smf78dcn());
            }
        }
        ,
        IoQueuingDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78ass(), header.smf78asl(), header.smf78asn());
            }
        }
        ,
        HyperPavDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf78hps(), header.smf78hpl(), header.smf78hpn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

