/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf78.subtype3;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class IoQueuingDataSection
extends SmfData {
    public static final int R783NHMA = 128;
    public static final int R783LCC = 64;
    public static final int R783LDC = 32;
    public static final int R783LCA = 16;
    public static final int R783LDCM = 8;
    public static final int R783LPAT = 4;
    public static final int R783HIND = 2;
    public static final int R783XIND = 1;
    public static final int R783L1FC = 128;
    public static final int R783LCTV = 64;
    public static final int R783LDTV = 32;

    private IoQueuingDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r783id2() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int r783dst() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean r783nhma() {
        return Util.ConvertFlag(this.data, this.r783dst(), 128);
    }

    public boolean r783lcc() {
        return Util.ConvertFlag(this.data, this.r783dst(), 64);
    }

    public boolean r783ldc() {
        return Util.ConvertFlag(this.data, this.r783dst(), 32);
    }

    public boolean r783lca() {
        return Util.ConvertFlag(this.data, this.r783dst(), 16);
    }

    public boolean r783ldcm() {
        return Util.ConvertFlag(this.data, this.r783dst(), 8);
    }

    public boolean r783lpat() {
        return Util.ConvertFlag(this.data, this.r783dst(), 4);
    }

    public boolean r783hind() {
        return Util.ConvertFlag(this.data, this.r783dst(), 2);
    }

    public boolean r783xind() {
        return Util.ConvertFlag(this.data, this.r783dst(), 1);
    }

    public int r783dstx() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean r783l1fc() {
        return Util.ConvertFlag(this.data, this.r783dstx(), 128);
    }

    public boolean r783lctv() {
        return Util.ConvertFlag(this.data, this.r783dstx(), 64);
    }

    public boolean r783ldtv() {
        return Util.ConvertFlag(this.data, this.r783dstx(), 32);
    }

    public long r783qsm() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long r783qct() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public int r783mcmn() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public int r783mcmx() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public int r783mcdf() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public long r783ptm() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long r783dpbm() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long r783cubm() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration r783cbtm() {
        return Util.Binary4x128US(this.data, 32);
    }

    public double r783cbtmSeconds() {
        return Util.ToSeconds(this.r783cbtm());
    }

    public long r783cbtmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration r783cmrm() {
        return Util.Binary4x128US(this.data, 36);
    }

    public double r783cmrmSeconds() {
        return Util.ToSeconds(this.r783cmrm());
    }

    public long r783cmrmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long r783sbsm() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public Duration r783dctm() {
        return Util.Binary4x128US(this.data, 44);
    }

    public double r783dctmSeconds() {
        return Util.ToSeconds(this.r783dctm());
    }

    public long r783dctmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public Duration r783ddtm() {
        return Util.Binary4x128US(this.data, 48);
    }

    public double r783ddtmSeconds() {
        return Util.ToSeconds(this.r783ddtm());
    }

    public long r783ddtmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public Duration r783csst() {
        return Util.Binary4x128US(this.data, 52);
    }

    public double r783csstSeconds() {
        return Util.ToSeconds(this.r783csst());
    }

    public long r783csstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public int r783hcnt() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int r783hix() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public long r783tmwm() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long r783trdm() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public static IoQueuingDataSection create(byte[] Data2, int offset, int length) {
        return new IoQueuingDataSection(Data2, offset, length);
    }

    static enum Field {
        r783id2(0, 2),
        r783dst(2, 1),
        r783dstx(3, 1),
        r783qsm(4, 4),
        r783qct(8, 4),
        r783mcmn(12, 2),
        r783mcmx(14, 2),
        r783mcdf(16, 2),
        r783ptm(20, 4),
        r783dpbm(24, 4),
        r783cubm(28, 4),
        r783cbtm(32, 4),
        r783cmrm(36, 4),
        r783sbsm(40, 4),
        r783dctm(44, 4),
        r783ddtm(48, 4),
        r783csst(52, 4),
        r783hcnt(56, 2),
        r783hix(58, 2),
        r783tmwm(60, 4),
        r783trdm(64, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

