/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf88;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class LogstreamSection
extends SmfData {
    public static final int SMF88LFD = 128;
    public static final int SMF88LFT = 64;
    public static final int SMF88LDS = 32;
    public static final int SMF88LZA = 16;

    private LogstreamSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public BigInteger smf88lit() {
        return Util.ConvertBigInteger(this.data, 0, 8);
    }

    public String smf88lsn() {
        return Util.ConvertEbcdic(this.data, 8, 26);
    }

    public int smf88lfl() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public boolean smf88lfd() {
        return Util.ConvertFlag(this.data, this.smf88lfl(), 128, Field.smf88lfl.length, 0);
    }

    public boolean smf88lft() {
        return Util.ConvertFlag(this.data, this.smf88lfl(), 64, Field.smf88lfl.length, 0);
    }

    public boolean smf88lds() {
        return Util.ConvertFlag(this.data, this.smf88lfl(), 32, Field.smf88lfl.length, 0);
    }

    public boolean smf88lza() {
        return Util.ConvertFlag(this.data, this.smf88lfl(), 16, Field.smf88lfl.length, 0);
    }

    public ZonedDateTime smf88ltd() {
        return Util.Binary8xStckTime(this.data, 36);
    }

    public BigInteger smf88ltdRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 36);
    }

    public long smf88lwi() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf88lib() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf88lab() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public double smf88lwb() {
        return Util.ConvertLongFPHex(this.data, 56);
    }

    public double smf88ldb() {
        return Util.ConvertLongFPHex(this.data, 64);
    }

    public long smf88lio() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf88lis() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public String smf88grp() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public static LogstreamSection create(byte[] Data2, int offset, int length) {
        return new LogstreamSection(Data2, offset, length);
    }

    static enum Field {
        smf88lit(0, 8),
        smf88lsn(8, 26),
        smf88lfl(34, 2),
        smf88ltd(36, 8),
        smf88lwi(44, 4),
        smf88lib(48, 4),
        smf88lab(52, 4),
        smf88lwb(56, 8),
        smf88ldb(64, 8),
        smf88lio(72, 4),
        smf88lis(76, 4),
        smf88grp(80, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

