/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.values.BoostClass;

public final class StateData
extends SmfData {
    public static final int SMF89T2NOTDEFINED = 128;
    public static final int SMF89T2ENABLED = 64;
    public static final int SMF89T2REGENTRY = 8;
    public static final int SMF89T2STATEENTRY = 4;
    public static final int SMF89T2NOREPORT = 2;
    public static final int SMF89T2LICENSEDUNDERPROD = 1;
    public static final int SMF89T2_zIIPBoost_Active = 128;
    public static final int SMF89T2_SpeedBoost_Active = 64;
    public static final int SMF89T2_BoostClass_Mask = 7;

    private StateData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89t2prodOwner() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public String smf89t2prodName() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public String smf89t2featureName() {
        return Util.ConvertEbcdic(this.data, 32, 16);
    }

    public String smf89t2prodVers() {
        return Util.ConvertEbcdic(this.data, 48, 2);
    }

    public String smf89t2prodRel() {
        return Util.ConvertEbcdic(this.data, 50, 2);
    }

    public String smf89t2prodMod() {
        return Util.ConvertEbcdic(this.data, 52, 2);
    }

    public String smf89t2prodId() {
        return Util.ConvertEbcdic(this.data, 54, 8);
    }

    public int smf89t2flags() {
        return Util.ConvertUnsignedBinary1(this.data, 62);
    }

    public boolean smf89t2notDefined() {
        return Util.ConvertFlag(this.data, this.smf89t2flags(), 128);
    }

    public boolean smf89t2enabled() {
        return Util.ConvertFlag(this.data, this.smf89t2flags(), 64);
    }

    public boolean smf89t2regEntry() {
        return Util.ConvertFlag(this.data, this.smf89t2flags(), 8);
    }

    public boolean smf89t2stateEntry() {
        return Util.ConvertFlag(this.data, this.smf89t2flags(), 4);
    }

    public boolean smf89t2noReport() {
        return Util.ConvertFlag(this.data, this.smf89t2flags(), 2);
    }

    public boolean smf89t2licensedUnderProd() {
        return Util.ConvertFlag(this.data, this.smf89t2flags(), 1);
    }

    public int smf89t2BoostInfo() {
        return Util.ConvertUnsignedBinary1(this.data, 63);
    }

    public boolean smf89t2ziipBoostActive() {
        return Util.ConvertFlag(this.data, this.smf89t2BoostInfo(), 128);
    }

    public boolean smf89t2SpeedBoostActive() {
        return Util.ConvertFlag(this.data, this.smf89t2BoostInfo(), 64);
    }

    public BoostClass smf30BoostClass() {
        if (this.smf89t2ziipBoostActive() || this.smf89t2SpeedBoostActive()) {
            return BoostClass.from(this.smf89t2BoostInfo() & 7);
        }
        return null;
    }

    public long smf89t2numInstances() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf89t2numCurrentInstances() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf89t2numInstancesInTrgs() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf89t2numNewRegistrations() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long smf89t2numNewTrgRegistrations() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public static StateData create(byte[] Data2, int offset, int length) {
        return new StateData(Data2, offset, length);
    }

    static enum Field {
        smf89t2prodOwner(0, 16),
        smf89t2prodName(16, 16),
        smf89t2featureName(32, 16),
        smf89t2prodVers(48, 2),
        smf89t2prodRel(50, 2),
        smf89t2prodMod(52, 2),
        smf89t2prodId(54, 8),
        smf89t2flags(62, 1),
        smf89t2BoostInfo(63, 1),
        smf89t2numInstances(64, 4),
        smf89t2numCurrentInstances(68, 4),
        smf89t2numInstancesInTrgs(72, 4),
        smf89t2numNewRegistrations(76, 4),
        smf89t2numNewTrgRegistrations(80, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

