/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class TrgUsageData
extends SmfData {
    private TrgUsageData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89trp() {
        return Util.ConvertEbcdic(this.data, 0, 56);
    }

    public String smf89tpo() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public String smf89tpn() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public String smf89tpv() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf89tpq() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String smf89tpi() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String smf89trgName() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public Duration smf89tct() {
        return Util.LongFpHex_x100S(this.data, 64);
    }

    public double smf89tctSeconds() {
        return Util.ToSeconds(this.smf89tct());
    }

    public double smf89tctRawValue() {
        return Util.ConvertLongFPHex(this.data, 64);
    }

    public Duration smf89tsr() {
        return Util.LongFpHex_x100S(this.data, 72);
    }

    public double smf89tsrSeconds() {
        return Util.ToSeconds(this.smf89tsr());
    }

    public double smf89tsrRawValue() {
        return Util.ConvertLongFPHex(this.data, 72);
    }

    public Duration smf89tzt() {
        return Util.LongFpHex_x100S(this.data, 80);
    }

    public double smf89tztSeconds() {
        return Util.ToSeconds(this.smf89tzt());
    }

    public double smf89tztRawValue() {
        return Util.ConvertLongFPHex(this.data, 80);
    }

    public byte[] smf89trgData() {
        if (this.data.length >= 96) {
            byte[] result = new byte[8];
            System.arraycopy(this.data, 88, result, 0, 8);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(88) + " Data length: " + Integer.toString(8));
    }

    public Duration smf89trgAsCpuTime() {
        if (this.smf89trgDataType() != 1) {
            throw new NotAvailableException("This method is only supported when (smf89trgDataType() == 1)");
        }
        return Util.LongFpHex_x100S(this.data, 76);
    }

    public long smf89trgAsBinary() {
        if (this.smf89trgDataType() != 2) {
            throw new NotAvailableException("This method is only supported when (smf89trgDataType() == 2)");
        }
        return Util.ConvertUnsignedBinary8(this.data, 76);
    }

    public BigInteger smf89trgAsBigInteger() {
        if (this.smf89trgDataType() != 2) {
            throw new NotAvailableException("This method is only supported when (smf89trgDataType() == 2)");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public double smf89trgLongFP() {
        if (this.smf89trgDataType() != 3) {
            throw new NotAvailableException("This method is only supported when (smf89trgDataType() == 3)");
        }
        return Util.ConvertLongFPHex(this.data, 76);
    }

    public int smf89trgDataType() {
        return Util.ConvertUnsignedBinary1(this.data, 96);
    }

    public static TrgUsageData create(byte[] Data2, int offset, int length) {
        return new TrgUsageData(Data2, offset, length);
    }

    static enum Field {
        smf89trp(0, 56),
        smf89tpo(0, 16),
        smf89tpn(16, 16),
        smf89tpv(32, 8),
        smf89tpq(40, 8),
        smf89tpi(48, 8),
        smf89trgName(56, 8),
        smf89tct(64, 8),
        smf89tsr(72, 8),
        smf89tzt(80, 8),
        smf89trgData(88, 8),
        smf89trgDataType(96, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

