/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.controlblock.CapacityChangeReason;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class CapacityChangeSection
extends SmfData {
    public static final int SMF90T34_RQSVSUS_Err = 128;
    public static final int SMF90T34_Capacity_Data_err = 64;
    public static final int SMF90T34_PCD_Rsvd_Exists = 32;

    private CapacityChangeSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf90t34CapacityChangeTime() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf90t34CapacityChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public long smf90t34Rqsvsus() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf90t34RctpCpuaActual() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf90t34RctpCpuaNominal() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf90t34RctpCpuaScalingFactor() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public int smf90t34CapacityAdjustmentInd() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public CapacityChangeReason smf90t34CapacityChangeReason() {
        return CapacityChangeReason.from(Util.ConvertUnsignedBinary1(this.data, 25));
    }

    public int smf90t34CapacityChangeReasonRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public int smf90t34Flags() {
        return Util.ConvertUnsignedBinary1(this.data, 26);
    }

    public boolean smf90t34RqsvsusErr() {
        return Util.ConvertFlag(this.data, this.smf90t34Flags(), 128);
    }

    public boolean smf90t34CapacityDataErr() {
        return Util.ConvertFlag(this.data, this.smf90t34Flags(), 64);
    }

    public boolean smf90t34PcdRsvdExists() {
        return Util.ConvertFlag(this.data, this.smf90t34Flags(), 32);
    }

    public long smf90t34RmctAdjnNominal() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public static CapacityChangeSection create(byte[] Data2, int offset, int length) {
        return new CapacityChangeSection(Data2, offset, length);
    }

    static enum Field {
        smf90t34CapacityChangeTime(0, 8),
        smf90t34Rqsvsus(8, 4),
        smf90t34RctpCpuaActual(12, 4),
        smf90t34RctpCpuaNominal(16, 4),
        smf90t34RctpCpuaScalingFactor(20, 4),
        smf90t34CapacityAdjustmentInd(24, 1),
        smf90t34CapacityChangeReason(25, 1),
        smf90t34Flags(26, 1),
        smf90t34RmctAdjnNominal(28, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

