/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.smf90.Smf90Record;
import com.blackhillsoftware.smf.smf90.WlmServicePolicySection;
import com.blackhillsoftware.svpol.ServicePolicy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class ServicePolicyBuilder {
    private static Object lockServicePolicy = new Object();
    private static Map<Long, Map<Integer, WlmServicePolicySection>> servicePolicySectionsByActivation = new HashMap<Long, Map<Integer, WlmServicePolicySection>>();
    private static Map<Long, Smf90Record> servicePolicyRecordsByActivation = new HashMap<Long, Smf90Record>();

    ServicePolicyBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Optional<Smf90Record> buildWlmServicePolicy(Smf90Record record) {
        Object object = lockServicePolicy;
        synchronized (object) {
            int required = record.wlmServicePolicySection().smf9024n();
            int sequence = record.wlmServicePolicySection().smf9024s();
            Long identifier = record.wlmServicePolicySection().smf9024i();
            if (!servicePolicyRecordsByActivation.containsKey(identifier) || sequence < servicePolicyRecordsByActivation.get(identifier).wlmServicePolicySection().smf9024s()) {
                servicePolicyRecordsByActivation.put(identifier, record);
            }
            servicePolicySectionsByActivation.computeIfAbsent(identifier, key -> new HashMap()).put(sequence, record.wlmServicePolicySection());
            if (servicePolicySectionsByActivation.get(identifier).size() < required) {
                return Optional.empty();
            }
            List sections = servicePolicySectionsByActivation.get(identifier).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(x -> (WlmServicePolicySection)x.getValue()).collect(Collectors.toList());
            int totalLength = sections.stream().map(x -> x.smf9024a().length).collect(Collectors.summingInt(Integer::intValue));
            byte[] combined = new byte[totalLength];
            int next = 1;
            int offset = 0;
            for (WlmServicePolicySection section : sections) {
                if (section.smf9024s() != next) continue;
                System.arraycopy(section.smf9024a(), 0, combined, offset, section.smf9024a().length);
                offset += section.smf9024a().length;
                ++next;
            }
            Smf90Record withPolicy = servicePolicyRecordsByActivation.get(identifier);
            withPolicy.set_m_ServicePolicy(ServicePolicy.create(combined, 0, combined.length, true));
            servicePolicyRecordsByActivation.remove(identifier);
            servicePolicySectionsByActivation.remove(identifier);
            return Optional.of(withPolicy);
        }
    }

    static List<Smf90Record> buildWlmServicePolicy(Iterable<Smf90Record> records) {
        ArrayList<Smf90Record> result = new ArrayList<Smf90Record>();
        HashMap<Long, List> sectionsByActivation = new HashMap<Long, List>();
        HashMap<Long, Smf90Record> recordsByActivation = new HashMap<Long, Smf90Record>();
        for (Smf90Record r90 : records) {
            if (r90.subType() != 24) {
                result.add(r90);
                continue;
            }
            if (!recordsByActivation.containsKey(r90.wlmServicePolicySection().smf9024i()) || r90.wlmServicePolicySection().smf9024s() < ((Smf90Record)recordsByActivation.get(r90.wlmServicePolicySection().smf9024i())).wlmServicePolicySection().smf9024s()) {
                recordsByActivation.put(r90.wlmServicePolicySection().smf9024i(), r90);
            }
            sectionsByActivation.computeIfAbsent(r90.wlmServicePolicySection().smf9024i(), key -> new ArrayList()).add(r90.wlmServicePolicySection());
        }
        for (List sections : sectionsByActivation.values()) {
            sections.sort(Comparator.comparing(WlmServicePolicySection::smf9024s));
            boolean complete = false;
            int totalLength = sections.stream().map(x -> x.smf9024a().length).collect(Collectors.summingInt(Integer::intValue));
            byte[] combined = new byte[totalLength];
            int next = 1;
            int offset = 0;
            for (WlmServicePolicySection section : sections) {
                if (section.smf9024s() == next) {
                    System.arraycopy(section.smf9024a(), 0, combined, offset, section.smf9024a().length);
                    offset += section.smf9024a().length;
                    ++next;
                }
                if (next <= section.smf9024n()) continue;
                complete = true;
            }
            Smf90Record withPolicy = (Smf90Record)recordsByActivation.get(((WlmServicePolicySection)sections.get(0)).smf9024i());
            withPolicy.set_m_ServicePolicy(ServicePolicy.create(combined, 0, combined.length, complete));
            result.add(withPolicy);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Smf90Record> incompleteServicePolicyRecords() {
        Object object = lockServicePolicy;
        synchronized (object) {
            ArrayList<Smf90Record> result = new ArrayList<Smf90Record>(servicePolicyRecordsByActivation.values());
            servicePolicyRecordsByActivation.clear();
            servicePolicySectionsByActivation.clear();
            return result;
        }
    }
}

