/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.BoostEvent;
import com.blackhillsoftware.smf.smf90.SystemRecoveryBoostRequestor;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class SystemRecoveryBoostSection
extends SmfData {
    public static final int SMF90T40_zIIPBoost_Active = 128;
    public static final int SMF90T40_SpeedBoost_Active = 64;
    public static final int SMF90T40_zIIPBoost_EndedByError = 32;
    public static final int SMF90T40_SpeedBoost_EndedByError = 16;
    public static final int SMF90T40_RPBoosts_Last_EndedByError = 8;
    public static final int SMF90T40_Boosts_EndedByTimer = 128;
    public static final int SMF90T40_Boosts_EndedByPgm = 64;
    public static final int SMF90T40_Boosts_EndedBySD = 32;
    public static final int SMF90T40_Boosts_EndedByError = 16;
    public static final int SMF90T40_RPB_Disabled = 1;
    public static final int SMF90T40_BoostClass_Mask = 7;

    private SystemRecoveryBoostSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf90t40Etod() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf90t40EtodRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public BoostEvent smf90t40Event() {
        int value = Util.ConvertSignedBinary4(this.data, 16);
        return BoostEvent.from(value);
    }

    public int smf90t40EventRawValue() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    public int smf90t40NumTransientZiipCores() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int smf90t40Flags0() {
        return Util.ConvertUnsignedBinary1(this.data, 22);
    }

    public boolean smf90t40ZiipBoostActive() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags0(), 128);
    }

    public boolean smf90t40SpeedBoostActive() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags0(), 64);
    }

    public boolean smf90t40ZiipBoostEndedByError() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags0(), 32);
    }

    public boolean smf90t40SpeedBoostEndedByError() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags0(), 16);
    }

    public boolean smf90t40RPBoostsLastEndedByError() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags0(), 8);
    }

    public BoostClass smf90t40BoostClass() {
        return BoostClass.from(Util.ConvertUnsignedBinary1(this.data, 22, 7));
    }

    public int smf90t40BoostClassRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 22, 7);
    }

    public int smf90t40Flags1() {
        return Util.ConvertUnsignedBinary1(this.data, 23);
    }

    public boolean smf90t40BoostsEndedByTimer() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags1(), 128);
    }

    public boolean smf90t40BoostsEndedByPgm() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags1(), 64);
    }

    public boolean smf90t40BoostsEndedBySD() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags1(), 32);
    }

    public boolean smf90t40BoostsEndedByError() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags1(), 16);
    }

    public boolean smf90t40RpbDisabled() {
        return Util.ConvertFlag(this.data, this.smf90t40Flags1(), 1);
    }

    public SystemRecoveryBoostRequestor smf90t40RpbStartRequestorId() {
        return this.smf90t40Event() == BoostEvent.RP_BOOSTS_START ? SystemRecoveryBoostRequestor.from(Util.ConvertUnsignedBinary1(this.data, 24)) : null;
    }

    public int smf90t40RpbStartRequestorIdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public SystemRecoveryBoostRequestor smf90t40RpStartRequestorId() {
        return this.smf90t40Event() == BoostEvent.RP_BOOSTS_START ? SystemRecoveryBoostRequestor.from(Util.ConvertUnsignedBinary1(this.data, 24)) : null;
    }

    public int smf90t40RpStartRequestorIdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public int smf90t40BoostLevel() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public Duration smf90t40RpbDuration() {
        return Util.Binary8StckInterval(this.data, 32);
    }

    public double smf90t40RpbDurationSeconds() {
        return Util.ToSeconds(this.smf90t40RpbDuration());
    }

    public long smf90t40RpbDurationRawValue() {
        return Util.ConvertSignedBinary8(this.data, 32);
    }

    public Duration smf90t40RpDuration() {
        return Util.Binary8StckInterval(this.data, 32);
    }

    public double smf90t40RpDurationSeconds() {
        return Util.ToSeconds(this.smf90t40RpDuration());
    }

    public long smf90t40RpDurationRawValue() {
        return Util.ConvertSignedBinary8(this.data, 32);
    }

    public Duration smf90t40RpbDurationDelta() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double smf90t40RpbDurationDeltaSeconds() {
        return Util.ToSeconds(this.smf90t40RpbDurationDelta());
    }

    public long smf90t40RpbDurationDeltaRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public Duration smf90t40RpbDurationPotential() {
        return Util.Binary8StckInterval(this.data, 48);
    }

    public double smf90t40RpbDurationPotentialSeconds() {
        return Util.ToSeconds(this.smf90t40RpbDurationPotential());
    }

    public long smf90t40RpbDurationPotentialRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    public Duration smf90t40RpbDurationPotentialDelta() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    public double smf90t40RpbDurationPotentialDeltaSeconds() {
        return Util.ToSeconds(this.smf90t40RpbDurationPotentialDelta());
    }

    public long smf90t40RpbDurationPotentialDeltaRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    public Duration smf90t40RpbDurationPotentialE() {
        return Util.Binary8StckInterval(this.data, 64);
    }

    public double smf90t40RpbDurationPotentialESeconds() {
        return Util.ToSeconds(this.smf90t40RpbDurationPotentialE());
    }

    public long smf90t40RpbDurationPotentialERawValue() {
        return Util.ConvertSignedBinary8(this.data, 64);
    }

    public Duration smf90t40RpbDurationPotentialEDelta() {
        return Util.Binary8StckInterval(this.data, 72);
    }

    public double smf90t40RpbDurationPotentialEDeltaSeconds() {
        return Util.ToSeconds(this.smf90t40RpbDurationPotentialEDelta());
    }

    public long smf90t40RpbDurationPotentialEDeltaRawValue() {
        return Util.ConvertSignedBinary8(this.data, 72);
    }

    public static SystemRecoveryBoostSection create(byte[] Data2, int offset, int length) {
        return new SystemRecoveryBoostSection(Data2, offset, length);
    }

    static enum Field {
        smf90t40Etod(0, 16),
        smf90t40Event(16, 4),
        smf90t40NumTransientZiipCores(20, 2),
        smf90t40Flags0(22, 1),
        smf90t40BoostClass(22, 1),
        smf90t40Flags1(23, 1),
        smf90t40RpbStartRequestorId(24, 1),
        smf90t40RpStartRequestorId(24, 1),
        smf90t40BoostLevel(25, 1),
        smf90t40RpbDuration(32, 8),
        smf90t40RpDuration(32, 8),
        smf90t40RpbDurationDelta(40, 8),
        smf90t40RpbDurationPotential(48, 8),
        smf90t40RpbDurationPotentialDelta(56, 8),
        smf90t40RpbDurationPotentialE(64, 8),
        smf90t40RpbDurationPotentialEDelta(72, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

