/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileType;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileAccess
extends SmfData {
    public static final int SMF92FAIT = 128;

    private FileAccess(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92fawt() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92fawtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public FileType smf92faft() {
        return FileType.fromValue(this.smf92faftRawValue());
    }

    public int smf92faftRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf92fafg() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf92fait() {
        return Util.ConvertFlag(this.data, this.smf92fafg(), 128);
    }

    public long smf92fain() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf92fadn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf92fati() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public String smf92fapn() {
        return Util.ConvertEbcdic(this.data, 24, 64);
    }

    public static FileAccess create(byte[] Data2, int offset, int length) {
        return new FileAccess(Data2, offset, length);
    }

    static enum Field {
        smf92fawt(0, 8),
        smf92faft(8, 1),
        smf92fafg(9, 1),
        smf92fain(12, 4),
        smf92fadn(16, 4),
        smf92fati(20, 4),
        smf92fapn(24, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

