/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.racf.FileIdentifier;
import com.blackhillsoftware.smf.smf92.FileType;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSecurityAttrChange
extends SmfData {
    public static final int SMF92AOLDSHARELIB = 16;
    public static final int SMF92AOLDAPFAUTH = 4;
    public static final int SMF92AOLDPROGCTL = 2;
    public static final int SMF92ANEWSHARELIB = 16;
    public static final int SMF92ANEWAPFAUTH = 4;
    public static final int SMF92ANEWPROGCTL = 2;

    private FileSecurityAttrChange(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92act() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92actRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public FileType smf92aty() {
        return FileType.fromValue(this.smf92atyRawValue());
    }

    public int smf92atyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf92aflg() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public long smf92ain() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf92adn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public String smf92afs() {
        return Util.ConvertEbcdic(this.data, 20, 44);
    }

    public long smf92aoldgenval() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public int smf92aoldgenvalsecbyte() {
        return Util.ConvertUnsignedBinary1(this.data, 67);
    }

    public boolean smf92aoldsharelib() {
        return Util.ConvertFlag(this.data, this.smf92aoldgenvalsecbyte(), 16);
    }

    public boolean smf92aoldapfauth() {
        return Util.ConvertFlag(this.data, this.smf92aoldgenvalsecbyte(), 4);
    }

    public boolean smf92aoldprogctl() {
        return Util.ConvertFlag(this.data, this.smf92aoldgenvalsecbyte(), 2);
    }

    public String smf92aoldsecattrsc() {
        return Util.ConvertEbcdic(this.data, 68, 4);
    }

    public String smf92aoldattrchar() {
        return Util.ConvertEbcdic(this.data, 68, 1);
    }

    public String smf92aoldshrlibc() {
        return Util.ConvertEbcdic(this.data, 69, 1);
    }

    public String smf92aoldapfauthc() {
        return Util.ConvertEbcdic(this.data, 70, 1);
    }

    public String smf92aoldpgmctlc() {
        return Util.ConvertEbcdic(this.data, 71, 1);
    }

    public long smf92anewgenval() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public int smf92anewgenvalsecbyte() {
        return Util.ConvertUnsignedBinary1(this.data, 75);
    }

    public boolean smf92anewsharelib() {
        return Util.ConvertFlag(this.data, this.smf92anewgenvalsecbyte(), 16);
    }

    public boolean smf92anewapfauth() {
        return Util.ConvertFlag(this.data, this.smf92anewgenvalsecbyte(), 4);
    }

    public boolean smf92anewprogctl() {
        return Util.ConvertFlag(this.data, this.smf92anewgenvalsecbyte(), 2);
    }

    public String smf92anewsecattrsc() {
        return Util.ConvertEbcdic(this.data, 76, 4);
    }

    public String smf92anewattrchar() {
        return Util.ConvertEbcdic(this.data, 76, 1);
    }

    public String smf92anewshrlibc() {
        return Util.ConvertEbcdic(this.data, 77, 1);
    }

    public String smf92anewapfauthc() {
        return Util.ConvertEbcdic(this.data, 78, 1);
    }

    public String smf92anewpgmctlc() {
        return Util.ConvertEbcdic(this.data, 79, 1);
    }

    public long smf92aownuid() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf92aowngid() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public String smf92aseclabel() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public FileIdentifier smf92aauditfid() {
        return FileIdentifier.create(this.data, 96, 16);
    }

    public long smf92acwdrc() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long smf92acwdrsn() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public int smf92apnl() {
        return Util.ConvertSignedBinary4(this.data, 140);
    }

    public String smf92apn() {
        if (this.data.length >= 144 + this.smf92apnl()) {
            return Util.ConvertEbcdic(this.data, 144, this.smf92apnl());
        }
        return null;
    }

    public static FileSecurityAttrChange create(byte[] Data2, int offset, int length) {
        return new FileSecurityAttrChange(Data2, offset, length);
    }

    static enum Field {
        smf92act(0, 8),
        smf92aty(8, 1),
        smf92aflg(9, 1),
        smf92ain(12, 4),
        smf92adn(16, 4),
        smf92afs(20, 44),
        smf92aoldgenval(64, 4),
        smf92aoldgenvalsecbyte(67, 1),
        smf92aoldsecattrsc(68, 4),
        smf92aoldattrchar(68, 1),
        smf92aoldshrlibc(69, 1),
        smf92aoldapfauthc(70, 1),
        smf92aoldpgmctlc(71, 1),
        smf92anewgenval(72, 4),
        smf92anewgenvalsecbyte(75, 1),
        smf92anewsecattrsc(76, 4),
        smf92anewattrchar(76, 1),
        smf92anewshrlibc(77, 1),
        smf92anewapfauthc(78, 1),
        smf92anewpgmctlc(79, 1),
        smf92aownuid(80, 4),
        smf92aowngid(84, 4),
        smf92aseclabel(88, 8),
        smf92aauditfid(96, 16),
        smf92acwdrc(132, 4),
        smf92acwdrsn(136, 4),
        smf92apnl(140, 4),
        smf92apn(144, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

