/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class IdentificationSection
extends SmfData {
    boolean zfs;

    private IdentificationSection(byte[] Data2, int offset, int length, boolean zFS) {
        super(Data2, offset, length);
        this.zfs = zFS;
    }

    public String smf92jbn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public LocalTime smf92rst() {
        return Util.Binary4x100STime(this.data, 8);
    }

    public long smf92rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public LocalDate smf92rsd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf92rsdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public String smf92stm() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf92rgd() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String smf92rud() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public long smf92uid() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf92gid() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf92pid() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf92pgd() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf92ssd() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf92api() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf92apg() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf92asg() {
        if (this.zfs) {
            throw new NotAvailableException("This field is not valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf92asid() {
        if (!this.zfs) {
            throw new NotAvailableException("This field is only valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf92rsc() {
        if (!this.zfs) {
            throw new NotAvailableException("This field is only valid for zFS records");
        }
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public static IdentificationSection create(byte[] Data2, int offset, int length, boolean zFS) {
        return new IdentificationSection(Data2, offset, length, zFS);
    }

    static enum Field {
        smf92jbn(0, 8),
        smf92rst(8, 4),
        smf92rsd(12, 4),
        smf92stm(16, 8),
        smf92asid(24, 4),
        smf92rsc(28, 4),
        smf92rgd(24, 8),
        smf92rud(32, 8),
        smf92uid(40, 4),
        smf92gid(44, 4),
        smf92pid(48, 4),
        smf92pgd(52, 4),
        smf92ssd(56, 4),
        smf92api(60, 4),
        smf92apg(64, 4),
        smf92asg(68, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

