/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public final class IdentificationSection
extends SmfData {
    private IdentificationSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf98jbn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public LocalTime smf98rst() {
        return Util.Binary4x100STime(this.data, 8);
    }

    public long smf98rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public LocalDate smf98rsd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf98rsdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public String smf98stp() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public LocalDateTime smf98intervalStart() {
        return Util.Binary8xStckLocalTime(this.data, 24);
    }

    public BigInteger smf98intervalStartRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public LocalDateTime smf98intervalEnd() {
        return Util.Binary8xStckLocalTime(this.data, 32);
    }

    public BigInteger smf98intervalEndRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public String smf98sysname() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public LocalDateTime smf98intervalStartEtod() {
        return Util.Binary16StckeLocalTime(this.data, 48);
    }

    public BigInteger smf98intervalStartEtodRawValue() {
        return Util.ConvertBigInteger(this.data, 48, 16);
    }

    public LocalDateTime smf98intervalEndEtod() {
        return Util.Binary16StckeLocalTime(this.data, 64);
    }

    public BigInteger smf98intervalEndEtodRawValue() {
        return Util.ConvertBigInteger(this.data, 64, 16);
    }

    public static IdentificationSection create(byte[] Data2, int offset, int length) {
        return new IdentificationSection(Data2, offset, length);
    }

    static enum Field {
        smf98jbn(0, 8),
        smf98rst(8, 4),
        smf98rsd(12, 4),
        smf98stp(16, 8),
        smf98intervalStart(24, 8),
        smf98intervalEnd(32, 8),
        smf98sysname(40, 8),
        smf98intervalStartEtod(48, 16),
        smf98intervalEndEtod(64, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

