/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98;

import java.util.HashMap;
import java.util.Map;

public enum JobSize {
    ALL(65535),
    LARGE(1),
    MEDIUM(2),
    SMALL(3),
    TINY(4),
    NOT_DEFINED(-2);

    private static Map<Integer, JobSize> valueMap;
    private final transient int jobSize;

    private JobSize(int jobSize) {
        this.jobSize = jobSize;
    }

    public static JobSize from(int value) {
        if (value == -1) {
            return ALL;
        }
        JobSize result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int jobSize() {
        return this.jobSize;
    }

    static {
        valueMap = new HashMap<Integer, JobSize>();
        for (JobSize x : JobSize.values()) {
            if (x.jobSize < 0) continue;
            valueMap.put(x.jobSize, x);
        }
    }
}

