/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98.ims;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf98.JobPriority;
import com.blackhillsoftware.smf.smf98.JobSize;
import com.blackhillsoftware.smf.smf98.ProcessorClass;
import java.math.BigInteger;
import java.time.Duration;

public final class AggregateStatistics
extends SmfData {
    private AggregateStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ProcessorClass cpu() {
        return ProcessorClass.from(this.cpuRawValue());
    }

    public int cpuRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public JobPriority prty() {
        return JobPriority.from(this.prtyRawValue());
    }

    public int prtyRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public JobSize size() {
        return JobSize.from(this.sizeRawValue());
    }

    public int sizeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int rgnCt() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public long tranCt() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger tranCtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public Duration avgPrT() {
        return Util.Binary8StckInterval(this.data, 16);
    }

    public double avgPrTSeconds() {
        return Util.ToSeconds(this.avgPrT());
    }

    public long avgPrTRawValue() {
        return Util.ConvertSignedBinary8(this.data, 16);
    }

    public Duration avgElT() {
        return Util.Binary8StckInterval(this.data, 24);
    }

    public double avgElTSeconds() {
        return Util.ToSeconds(this.avgElT());
    }

    public long avgElTRawValue() {
        return Util.ConvertSignedBinary8(this.data, 24);
    }

    public static AggregateStatistics create(byte[] Data2, int offset, int length) {
        return new AggregateStatistics(Data2, offset, length);
    }

    static enum Field {
        cpu(0, 2),
        prty(2, 2),
        size(4, 2),
        rgnCt(6, 2),
        tranCt(8, 8),
        avgPrT(16, 8),
        avgElT(24, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

