/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98.zos;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf98.JobPriority;
import com.blackhillsoftware.smf.smf98.ProcessorClass;
import com.blackhillsoftware.smf.smf98.zos.PriorityBucket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class WorkUnitPriorityBucket
extends SmfData {
    public static final int HIGH = 0;
    public static final int MEDIUM = 1;
    public static final int LOW = 2;
    public static final int DISCRETIONARY = 3;

    private WorkUnitPriorityBucket(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int procClass() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public ProcessorClass processorClass() {
        return ProcessorClass.from(this.procClass());
    }

    public int contributingWUQs() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sigDelayWUQs() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public List<PriorityBucket<Long>> maxQDepth() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 8 + i * Field.maxQDepth.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> qDepthDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 24 + i * Field.qDepthDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> avgQDepthPerSample() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 40 + i * Field.avgQDepthPerSample.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> avgQDepthPerSamplePerWuq() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 56 + i * Field.avgQDepthPerSamplePerWuq.length)));
        }
        return result;
    }

    public List<PriorityBucket<Duration>> maxDispDelay() {
        ArrayList<PriorityBucket<Duration>> result = new ArrayList<PriorityBucket<Duration>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Duration>(JobPriority.from(i + 1), Util.Binary8StckInterval(this.data, 72 + i * Field.maxDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Double>> maxDispDelaySeconds() {
        ArrayList<PriorityBucket<Double>> result = new ArrayList<PriorityBucket<Double>>();
        List<PriorityBucket<Duration>> durations = this.maxDispDelay();
        for (int i = 0; i < durations.size(); ++i) {
            result.add(new PriorityBucket<Double>(JobPriority.from(i + 1), Util.ToSeconds(durations.get(i).value())));
        }
        return result;
    }

    public List<PriorityBucket<Long>> maxDispDelayRawValue() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertSignedBinary8(this.data, 72 + i * Field.maxDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Duration>> totDispDelayDelta() {
        ArrayList<PriorityBucket<Duration>> result = new ArrayList<PriorityBucket<Duration>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Duration>(JobPriority.from(i + 1), Util.Binary8StckInterval(this.data, 104 + i * Field.totDispDelayDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Double>> totDispDelayDeltaSeconds() {
        ArrayList<PriorityBucket<Double>> result = new ArrayList<PriorityBucket<Double>>();
        List<PriorityBucket<Duration>> durations = this.totDispDelayDelta();
        for (int i = 0; i < durations.size(); ++i) {
            result.add(new PriorityBucket<Double>(JobPriority.from(i + 1), Util.ToSeconds(durations.get(i).value())));
        }
        return result;
    }

    public List<PriorityBucket<Long>> totDispDelayDeltaRawValue() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertSignedBinary8(this.data, 104 + i * Field.totDispDelayDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> workUnitDispDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 136 + i * Field.workUnitDispDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Duration>> avgDispDelay() {
        ArrayList<PriorityBucket<Duration>> result = new ArrayList<PriorityBucket<Duration>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Duration>(JobPriority.from(i + 1), Util.Binary8StckInterval(this.data, 152 + i * Field.avgDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Double>> avgDispDelaySeconds() {
        ArrayList<PriorityBucket<Double>> result = new ArrayList<PriorityBucket<Double>>();
        List<PriorityBucket<Duration>> durations = this.avgDispDelay();
        for (int i = 0; i < durations.size(); ++i) {
            result.add(new PriorityBucket<Double>(JobPriority.from(i + 1), Util.ToSeconds(durations.get(i).value())));
        }
        return result;
    }

    public List<PriorityBucket<Long>> avgDispDelayRawValue() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertSignedBinary8(this.data, 152 + i * Field.avgDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> majorTimeSliceDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 184 + i * Field.majorTimeSliceDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> minorTimeSliceDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 200 + i * Field.minorTimeSliceDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Duration>> sdMaxDispDelay() {
        ArrayList<PriorityBucket<Duration>> result = new ArrayList<PriorityBucket<Duration>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Duration>(JobPriority.from(i + 1), Util.Binary8StckInterval(this.data, 216 + i * Field.sdMaxDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Double>> sdMaxDispDelaySeconds() {
        ArrayList<PriorityBucket<Double>> result = new ArrayList<PriorityBucket<Double>>();
        List<PriorityBucket<Duration>> durations = this.sdMaxDispDelay();
        for (int i = 0; i < durations.size(); ++i) {
            result.add(new PriorityBucket<Double>(JobPriority.from(i + 1), Util.ToSeconds(durations.get(i).value())));
        }
        return result;
    }

    public List<PriorityBucket<Long>> sdMaxDispDelayRawValue() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertSignedBinary8(this.data, 216 + i * Field.sdMaxDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Duration>> sdTotDispDelayDelta() {
        ArrayList<PriorityBucket<Duration>> result = new ArrayList<PriorityBucket<Duration>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Duration>(JobPriority.from(i + 1), Util.Binary8StckInterval(this.data, 248 + i * Field.sdTotDispDelayDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Double>> sdTotDispDelayDeltaSeconds() {
        ArrayList<PriorityBucket<Double>> result = new ArrayList<PriorityBucket<Double>>();
        List<PriorityBucket<Duration>> durations = this.sdTotDispDelayDelta();
        for (int i = 0; i < durations.size(); ++i) {
            result.add(new PriorityBucket<Double>(JobPriority.from(i + 1), Util.ToSeconds(durations.get(i).value())));
        }
        return result;
    }

    public List<PriorityBucket<Long>> sdTotDispDelayDeltaRawValue() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertSignedBinary8(this.data, 248 + i * Field.sdTotDispDelayDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> sdWorkUnitDispDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 280 + i * Field.sdWorkUnitDispDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Duration>> sdAvgDispDelay() {
        ArrayList<PriorityBucket<Duration>> result = new ArrayList<PriorityBucket<Duration>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Duration>(JobPriority.from(i + 1), Util.Binary8StckInterval(this.data, 296 + i * Field.sdAvgDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Double>> smf981PbSdAvgDispDelaySeconds() {
        ArrayList<PriorityBucket<Double>> result = new ArrayList<PriorityBucket<Double>>();
        List<PriorityBucket<Duration>> durations = this.sdAvgDispDelay();
        for (int i = 0; i < durations.size(); ++i) {
            result.add(new PriorityBucket<Double>(JobPriority.from(i + 1), Util.ToSeconds(durations.get(i).value())));
        }
        return result;
    }

    public List<PriorityBucket<Long>> sdAvgDispDelayRawValue() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertSignedBinary8(this.data, 296 + i * Field.sdAvgDispDelay.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> sdMajorTimeSliceDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 328 + i * Field.sdMajorTimeSliceDelta.length)));
        }
        return result;
    }

    public List<PriorityBucket<Long>> sdMinorTimeSliceDelta() {
        ArrayList<PriorityBucket<Long>> result = new ArrayList<PriorityBucket<Long>>();
        for (int i = 0; i < 4; ++i) {
            result.add(new PriorityBucket<Long>(JobPriority.from(i + 1), Util.ConvertUnsignedBinary4(this.data, 344 + i * Field.sdMinorTimeSliceDelta.length)));
        }
        return result;
    }

    public static WorkUnitPriorityBucket create(byte[] Data2, int offset, int length) {
        return new WorkUnitPriorityBucket(Data2, offset, length);
    }

    static enum Field {
        procClass(0, 2),
        contributingWUQs(2, 2),
        sigDelayWUQs(4, 2),
        maxQDepth(8, 4),
        qDepthDelta(24, 4),
        avgQDepthPerSample(40, 4),
        avgQDepthPerSamplePerWuq(56, 4),
        maxDispDelay(72, 8),
        totDispDelayDelta(104, 8),
        workUnitDispDelta(136, 4),
        avgDispDelay(152, 8),
        majorTimeSliceDelta(184, 4),
        minorTimeSliceDelta(200, 4),
        sdMaxDispDelay(216, 8),
        sdTotDispDelayDelta(248, 8),
        sdWorkUnitDispDelta(280, 4),
        sdAvgDispDelay(296, 8),
        sdMajorTimeSliceDelta(328, 4),
        sdMinorTimeSliceDelta(344, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

